/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.collect.Lists;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.screen.generic.OptionEntriesScreen;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import static me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget.entrySize;

public enum SearchFilteringRuleType implements FilteringRuleType<SearchFilteringRule> {
    INSTANCE;
    
    @Override
    public class_2487 saveTo(SearchFilteringRule rule, class_2487 tag) {
        tag.method_10582("filter", rule.filterStr);
        tag.method_10556("show", rule.show);
        return tag;
    }
    
    @Override
    public SearchFilteringRule readFrom(class_2487 tag) {
        String filter = tag.method_10558("filter");
        boolean show = tag.method_10577("show");
        return new SearchFilteringRule(filter, show);
    }
    
    @Override
    public SearchFilteringRule createNew() {
        return new SearchFilteringRule("", false);
    }
    
    @Override
    public class_2561 getTitle(SearchFilteringRule rule) {
        return class_2561.method_43471("rule.roughlyenoughitems.filtering.search");
    }
    
    @Override
    public class_2561 getSubtitle(SearchFilteringRule rule) {
        return class_2561.method_43471("rule.roughlyenoughitems.filtering.search.subtitle");
    }
    
    @Override
    @Nullable
    public Function<class_437, class_437> createEntryScreen(SearchFilteringRule rule) {
        return screen -> new OptionEntriesScreen(class_2561.method_43471("config.roughlyenoughitems.filteringRulesScreen"), screen) {
            TextFieldListEntry entry = null;
            BooleanListEntry show = null;
            List<EntryWidget> entryStacks = new ArrayList<>();
            
            @Override
            public void addEntries(Consumer<ListEntry> entryConsumer) {
                addEmpty(entryConsumer, 10);
                addText(entryConsumer, class_2561.method_43471("rule.roughlyenoughitems.filtering.search.filter").method_27692(class_124.field_1080));
                entryConsumer.accept(entry = new TextFieldListEntry(field_22789 - 36, widget -> {
                    widget.method_1880(9999);
                    widget.method_1863(searchTerm -> {
                        SearchFilter filter = SearchProvider.getInstance().createFilter(searchTerm);
                        entryStacks = EntryRegistry.getInstance().getEntryStacks().parallel()
                                .filter(filter)
                                .map(EntryStack::normalize)
                                .map(stack -> new EntryWidget(new Rectangle(0, 0, 18, 18)).noBackground().entry(stack))
                                .collect(Collectors.toList());
                    });
                    if (entry != null) widget.method_1852(entry.getWidget().method_1882());
                    else widget.method_1852(rule.filterStr);
                }));
                addEmpty(entryConsumer, 10);
                addText(entryConsumer, class_2561.method_43471("rule.roughlyenoughitems.filtering.search.show").method_27692(class_124.field_1080));
                Function<Boolean, class_2561> function = bool -> {
                    return class_2561.method_43471("rule.roughlyenoughitems.filtering.search.show." + bool);
                };
                entryConsumer.accept(show = new BooleanListEntry(field_22789 - 36, show == null ? rule.show : show.getBoolean(), function));
                addEmpty(entryConsumer, 10);
                entryConsumer.accept(new SubListEntry(() -> function.apply(show == null ? rule.show : show.getBoolean()),
                        Collections.singletonList(new EntryStacksRuleEntry(() -> entryStacks))));
            }
            
            @Override
            public void save() {
                rule.setFilter(entry.getWidget().method_1882());
                rule.show = show.getBoolean();
            }
        };
    }
    
    @Override
    public boolean isSingular() {
        return false;
    }
    
    public static class EntryStacksRuleEntry extends OptionEntriesScreen.ListEntry {
        private final Supplier<Iterable<EntryWidget>> entryStacks;
        private int totalHeight;
        
        public EntryStacksRuleEntry(Supplier<Iterable<EntryWidget>> entryStacks) {
            this.entryStacks = entryStacks;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            BatchedEntryRendererManager<EntryWidget> manager = new BatchedEntryRendererManager<>();
            int entrySize = entrySize();
            int width = entryWidth / entrySize;
            int i = 0;
            for (EntryWidget stack : entryStacks.get()) {
                stack.getBounds().setLocation(x + (i % width) * entrySize, y + (i / width) * entrySize);
                if (stack.getBounds().getMaxY() >= 0 && stack.getBounds().getY() <= class_310.method_1551().method_22683().method_4502()) {
                    manager.add(stack);
                }
                i++;
            }
            manager.render(graphics, mouseX, mouseY, delta);
            totalHeight = (i / width + 1) * entrySize;
        }
        
        @Override
        public int getItemHeight() {
            return totalHeight;
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Lists.newArrayList();
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Lists.newArrayList();
        }
    }
}
