/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.displays;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.client.displays.ClientsidedRecipeBookDisplay;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.CraftingDisplay;
import net.minecraft.class_10298;
import net.minecraft.class_10300;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class ClientsidedCraftingDisplay
extends BasicDisplay
implements CraftingDisplay,
ClientsidedRecipeBookDisplay {
    private final Optional<class_10298> id;

    public ClientsidedCraftingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_10298> id) {
        super(inputs, outputs, Optional.empty());
        this.id = id;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    @Override
    public Optional<class_10298> recipeDisplayId() {
        return this.id;
    }

    public static class Shapeless
    extends ClientsidedCraftingDisplay {
        public static final DisplaySerializer<Shapeless> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)Codec.INT.xmap(class_10298::new, class_10298::comp_3267).optionalFieldOf("id").forGetter(ClientsidedCraftingDisplay::recipeDisplayId)).apply((Applicative)instance, Shapeless::new)), (class_9139)class_9139.method_56436((class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), BasicDisplay::getInputEntries, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), BasicDisplay::getOutputEntries, (class_9139)class_9135.method_56382((class_9139)class_9135.field_49675.method_56432(class_10298::new, class_10298::comp_3267)), ClientsidedCraftingDisplay::recipeDisplayId, Shapeless::new), (boolean)false);

        public Shapeless(class_10301 recipe, Optional<class_10298> id) {
            super(EntryIngredients.ofSlotDisplays((Iterable)recipe.comp_3271()), List.of(EntryIngredients.ofSlotDisplay((class_10302)recipe.comp_3258())), id);
        }

        public Shapeless(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_10298> id) {
            super(inputs, outputs, id);
        }

        @Override
        public boolean isShapeless() {
            return true;
        }

        public int getWidth() {
            return this.getInputEntries().size() > 4 ? 3 : 2;
        }

        public int getHeight() {
            return this.getInputEntries().size() > 4 ? 3 : 2;
        }

        public int getInputWidth(int craftingWidth, int craftingHeight) {
            return craftingWidth * craftingHeight <= this.getInputEntries().size() ? craftingWidth : Math.min(this.getInputEntries().size(), 3);
        }

        public int getInputHeight(int craftingWidth, int craftingHeight) {
            return (int)Math.ceil((double)this.getInputEntries().size() / (double)this.getInputWidth(craftingWidth, craftingHeight));
        }

        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }

    public static class Shaped
    extends ClientsidedCraftingDisplay {
        public static final DisplaySerializer<Shaped> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)Codec.INT.xmap(class_10298::new, class_10298::comp_3267).optionalFieldOf("id").forGetter(ClientsidedCraftingDisplay::recipeDisplayId), (App)Codec.INT.fieldOf("width").forGetter(Shaped::getWidth), (App)Codec.INT.fieldOf("height").forGetter(Shaped::getHeight)).apply((Applicative)instance, Shaped::new)), (class_9139)class_9139.method_56906((class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), BasicDisplay::getInputEntries, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), BasicDisplay::getOutputEntries, (class_9139)class_9135.method_56382((class_9139)class_9135.field_49675.method_56432(class_10298::new, class_10298::comp_3267)), ClientsidedCraftingDisplay::recipeDisplayId, (class_9139)class_9135.field_49675, Shaped::getWidth, (class_9139)class_9135.field_49675, Shaped::getHeight, Shaped::new), (boolean)false);
        private final int width;
        private final int height;

        public Shaped(class_10300 recipe, Optional<class_10298> id) {
            super(EntryIngredients.ofSlotDisplays((Iterable)recipe.comp_3270()), List.of(EntryIngredients.ofSlotDisplay((class_10302)recipe.comp_3258())), id);
            this.width = recipe.comp_3268();
            this.height = recipe.comp_3269();
        }

        public Shaped(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_10298> id, int width, int height) {
            super(inputs, outputs, id);
            this.width = width;
            this.height = height;
        }

        @Override
        public boolean isShapeless() {
            return false;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }
}

