/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.cooking;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.common.displays.cooking.CookingDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class DefaultCookingCategory
implements DisplayCategory<CookingDisplay> {
    private CategoryIdentifier<? extends CookingDisplay> identifier;
    private EntryStack<?> logo;
    private String categoryName;
    private double defaultCookingTime;

    public DefaultCookingCategory(CategoryIdentifier<? extends CookingDisplay> identifier, EntryStack<?> logo, String categoryName, double defaultCookingTime) {
        this.identifier = identifier;
        this.logo = logo;
        this.categoryName = categoryName;
        this.defaultCookingTime = defaultCookingTime;
    }

    public List<Widget> setupDisplay(CookingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        DecimalFormat df = new DecimalFormat("###.##");
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 61, startPoint.y + 9)));
        widgets.add(Widgets.createBurningFire((Point)new Point(startPoint.x + 1, startPoint.y + 20)).animationDurationMS(10000.0));
        if (display.cookTime().isPresent() && display.xp().isPresent()) {
            widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 5, bounds.y + 5), (class_2561)class_2561.method_43469((String)"category.rei.cooking.time&xp", (Object[])new Object[]{df.format(display.xp().getAsDouble()), df.format(display.cookTime().getAsDouble() / 20.0)})).noShadow().rightAligned().color(-12566464, -4473925));
        }
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 24, startPoint.y + 8)).animationDurationTicks(display.cookTime().orElse(this.defaultCookingTime)));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 61, startPoint.y + 9)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).markInput());
        return widgets;
    }

    public DisplayRenderer getDisplayRenderer(CookingDisplay display) {
        return SimpleDisplayRenderer.from(Collections.singletonList((EntryIngredient)display.getInputEntries().get(0)), (List)display.getOutputEntries());
    }

    public int getDisplayHeight() {
        return 49;
    }

    public CategoryIdentifier<? extends CookingDisplay> getCategoryIdentifier() {
        return this.identifier;
    }

    public Renderer getIcon() {
        return this.logo;
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)this.categoryName);
    }
}

