/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import org.jetbrains.annotations.Nullable;

public interface CraftingDisplay
extends SimpleGridMenuDisplay {
    public boolean isShapeless();

    public static int getSlotWithSize(CraftingDisplay display, int index, int craftingGridWidth) {
        return CraftingDisplay.getSlotWithSize(display.getInputWidth(craftingGridWidth, 3), index, craftingGridWidth);
    }

    public static int getSlotWithSize(int recipeWidth, int index, int craftingGridWidth) {
        int x = index % recipeWidth;
        int y = (index - x) / recipeWidth;
        return craftingGridWidth * y + x;
    }

    default public <T extends class_1703> List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(menuWidth * menuHeight);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            list.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            list.set(CraftingDisplay.getSlotWithSize(this, i, menuWidth), (EntryIngredient)this.getInputEntries().get(i));
        }
        return list;
    }

    default public List<InputIngredient<EntryStack<?>>> getInputIngredients(@Nullable class_1703 menu, @Nullable class_1657 player) {
        return this.getInputIngredients(3, 3);
    }

    default public List<InputIngredient<EntryStack<?>>> getInputIngredients(int craftingWidth, int craftingHeight) {
        int inputWidth = this.getInputWidth(craftingWidth, craftingHeight);
        int inputHeight = this.getInputHeight(craftingWidth, craftingHeight);
        HashMap<IntIntImmutablePair, InputIngredient> grid = new HashMap<IntIntImmutablePair, InputIngredient>();
        List inputEntries = this.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            EntryIngredient stacks = (EntryIngredient)inputEntries.get(i);
            if (stacks.isEmpty()) continue;
            int index = CraftingDisplay.getSlotWithSize(inputWidth, i, craftingWidth);
            int x = i % inputWidth;
            int y = i / inputWidth;
            grid.put(new IntIntImmutablePair(x, y), InputIngredient.of((int)index, (int)(3 * y + x), (List)stacks));
        }
        ArrayList list = new ArrayList(craftingWidth * craftingHeight);
        int n = craftingWidth * craftingHeight;
        for (int i = 0; i < n; ++i) {
            list.add(InputIngredient.empty((int)i));
        }
        for (int x = 0; x < craftingWidth; ++x) {
            for (int y = 0; y < craftingHeight; ++y) {
                InputIngredient ingredient = (InputIngredient)grid.get(new IntIntImmutablePair(x, y));
                if (ingredient == null) continue;
                int index = craftingWidth * y + x;
                list.set(index, ingredient);
            }
        }
        return list;
    }
}

