/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting.recipebook;

import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.plugin.client.displays.ClientsidedCraftingDisplay;
import me.shedaniel.rei.plugin.client.displays.ClientsidedRecipeBookDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;

@Environment(value=EnvType.CLIENT)
public class DefaultRecipeBookHandler
implements TransferHandler {
    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        if (context.getDisplay() instanceof SimpleGridMenuDisplay && ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        Display display = context.getDisplay();
        AbstractContainerMenu abstractContainerMenu = context.getMenu();
        if (!(abstractContainerMenu instanceof RecipeBookMenu)) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        RecipeBookMenu container = (RecipeBookMenu)abstractContainerMenu;
        if (container == null) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        return TransferHandler.ApplicabilityResult.createApplicable();
    }

    public TransferHandler.Result handle(TransferHandler.Context context) {
        ClientsidedRecipeBookDisplay defaultDisplay;
        RecipeBookMenu container = (RecipeBookMenu)context.getMenu();
        Display display = context.getDisplay();
        if (display instanceof ClientsidedCraftingDisplay) {
            ClientsidedCraftingDisplay craftingDisplay = (ClientsidedCraftingDisplay)display;
            if (craftingDisplay.recipeDisplayId().isPresent()) {
                int h = -1;
                int w = -1;
                if (container instanceof CraftingMenu) {
                    h = 3;
                    w = 3;
                } else if (container instanceof InventoryMenu) {
                    h = 2;
                    w = 2;
                }
                if (h == -1 || w == -1) {
                    return TransferHandler.Result.createNotApplicable();
                }
                RecipeDisplayId id = craftingDisplay.recipeDisplayId().get();
                if (craftingDisplay.getHeight() > h || craftingDisplay.getWidth() > w) {
                    return TransferHandler.Result.createFailed((Component)Component.translatable((String)"error.rei.transfer.too_small", (Object[])new Object[]{h, w}));
                }
                if (!context.isActuallyCrafting()) {
                    return TransferHandler.Result.createSuccessful();
                }
                context.getMinecraft().setScreen((Screen)context.getContainerScreen());
                AbstractContainerScreen abstractContainerScreen = context.getContainerScreen();
                if (abstractContainerScreen instanceof AbstractRecipeBookScreen) {
                    AbstractRecipeBookScreen screen = (AbstractRecipeBookScreen)abstractContainerScreen;
                    screen.recipeBookComponent.ghostSlots.clear();
                }
                context.getMinecraft().gameMode.handlePlaceRecipe(container.containerId, id, context.isStackedCrafting());
                return TransferHandler.Result.createSuccessful();
            }
        } else if (display instanceof ClientsidedRecipeBookDisplay && (defaultDisplay = (ClientsidedRecipeBookDisplay)display).recipeDisplayId().isPresent()) {
            RecipeDisplayId id = defaultDisplay.recipeDisplayId().get();
            if (!context.isActuallyCrafting()) {
                return TransferHandler.Result.createSuccessful();
            }
            context.getMinecraft().setScreen((Screen)context.getContainerScreen());
            AbstractContainerScreen abstractContainerScreen = context.getContainerScreen();
            if (abstractContainerScreen instanceof AbstractRecipeBookScreen) {
                AbstractRecipeBookScreen screen = (AbstractRecipeBookScreen)abstractContainerScreen;
                screen.recipeBookComponent.ghostSlots.clear();
            }
            context.getMinecraft().gameMode.handlePlaceRecipe(container.containerId, id, context.isStackedCrafting());
            return TransferHandler.Result.createSuccessful();
        }
        return TransferHandler.Result.createNotApplicable();
    }

    public double getPriority() {
        return -20.0;
    }
}

