/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MapExtendingCraftingDisplay
extends DefaultCraftingDisplay {
    public static final DisplaySerializer<MapExtendingCraftingDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("i").forGetter(d -> d.i), (App)ResourceLocation.CODEC.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation)).apply((Applicative)instance, MapExtendingCraftingDisplay::new)), (StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, d -> d.i, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), BasicDisplay::getDisplayLocation, MapExtendingCraftingDisplay::new));
    private final int i;

    public MapExtendingCraftingDisplay(int i, Optional<ResourceLocation> id) {
        super(MapExtendingCraftingDisplay.getInputs(i), List.of(MapExtendingCraftingDisplay.mapWith("X", i + 1, 1)), id);
        this.i = i;
    }

    private static List<EntryIngredient> getInputs(int i) {
        EntryIngredient[] inputs = new EntryIngredient[9];
        for (int j = 0; j < 9; ++j) {
            inputs[j] = j == 4 ? MapExtendingCraftingDisplay.mapWith("X", i, 1) : EntryIngredients.of((ItemLike)Items.PAPER);
        }
        return List.of(inputs);
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public static EntryIngredient mapWith(String mapId, int scale, int count) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            return MapExtendingCraftingDisplay.mapWithClient(mapId, scale, count);
        }
        return EntryIngredients.of((ItemLike)Items.FILLED_MAP, (int)count);
    }

    @Environment(value=EnvType.CLIENT)
    public static EntryIngredient mapWithClient(String mapId, int scale, int count) {
        EntryIngredient stacks = EntryIngredients.of((ItemLike)Items.FILLED_MAP, (int)count);
        String unknown = I18n.get((String)"filled_map.unknown", (Object[])new Object[0]);
        for (EntryStack stack : stacks) {
            stack.tooltipProcessor(($, tooltip) -> {
                tooltip.entries().removeIf(entry -> entry.isText() && entry.getAsText().getString().equals(unknown));
                return tooltip;
            });
            stack.tooltip(new Component[]{Component.translatable((String)"filled_map.id", (Object[])new Object[]{mapId}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"filled_map.scale", (Object[])new Object[]{1 << scale}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"filled_map.level", (Object[])new Object[]{scale, 4}).withStyle(ChatFormatting.GRAY)});
        }
        return stacks;
    }

    @Override
    public boolean isShapeless() {
        return false;
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }
}

