/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.client.categories.crafting.filler.CraftingRecipeFiller;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShieldDecorationRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class ShieldDecorationRecipeFiller
implements CraftingRecipeFiller<ShieldDecorationRecipe> {
    static List<Pair<DyeColor, ItemStack>> randomizeBanners() {
        ArrayList<Pair<DyeColor, ItemStack>> out = new ArrayList<Pair<DyeColor, ItemStack>>();
        DyeColor[] colors = DyeColor.values();
        Random random = new Random();
        for (DyeColor color : colors) {
            Optional bannerOptional = BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)(color.getName() + "_banner")));
            if (bannerOptional.isEmpty()) continue;
            out.add((Pair<DyeColor, ItemStack>)Pair.of((Object)color, (Object)new ItemStack((ItemLike)bannerOptional.get())));
            for (int i = 0; i < 2; ++i) {
                ArrayList<BannerPatternLayers.Layer> layers = new ArrayList<BannerPatternLayers.Layer>();
                Optional registry = BasicDisplay.registryAccess().lookup(Registries.BANNER_PATTERN);
                if (registry.isEmpty()) {
                    return Collections.emptyList();
                }
                Holder[] allPatterns = (Holder[])((Registry)registry.get()).listElements().toArray(Holder[]::new);
                for (int j = 0; j < 2; ++j) {
                    Holder pattern = allPatterns[random.nextInt(allPatterns.length - 1) + 1];
                    layers.add(new BannerPatternLayers.Layer(pattern, colors[random.nextInt(colors.length)]));
                }
                ItemStack banner = new ItemStack((ItemLike)bannerOptional.get());
                banner.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers(layers));
                out.add((Pair<DyeColor, ItemStack>)Pair.of((Object)color, (Object)banner));
            }
        }
        return out;
    }

    @Override
    public Collection<Display> apply(RecipeHolder<ShieldDecorationRecipe> recipe) {
        ArrayList<Display> displays = new ArrayList<Display>();
        EntryIngredient shield = EntryIngredients.of((ItemLike)Items.SHIELD);
        EntryIngredient.Builder inputsBuilder = EntryIngredient.builder();
        EntryIngredient.Builder outputsBuilder = EntryIngredient.builder();
        for (Pair<DyeColor, ItemStack> pair : ShieldDecorationRecipeFiller.randomizeBanners()) {
            inputsBuilder.add(EntryStacks.of((ItemStack)((ItemStack)pair.getSecond())));
            outputsBuilder.add(ShieldDecorationRecipeFiller.createOutput((DyeColor)pair.getFirst(), (ItemStack)pair.getSecond()));
        }
        EntryIngredient inputs = inputsBuilder.build();
        EntryIngredient outputs = outputsBuilder.build();
        EntryIngredient.unifyFocuses((EntryIngredient[])new EntryIngredient[]{inputs, outputs});
        displays.add((Display)new DefaultCustomShapelessDisplay(List.of(inputs, shield), List.of(outputs), Optional.of(recipe.id().location())));
        return displays;
    }

    private static EntryStack<ItemStack> createOutput(DyeColor color, ItemStack banner) {
        ItemStack output = new ItemStack((ItemLike)Items.SHIELD);
        output.set(DataComponents.BANNER_PATTERNS, (Object)((BannerPatternLayers)banner.get(DataComponents.BANNER_PATTERNS)));
        output.set(DataComponents.BASE_COLOR, (Object)((BannerItem)banner.getItem()).getColor());
        return EntryStacks.of((ItemStack)output);
    }

    @Override
    public Class<ShieldDecorationRecipe> getRecipeClass() {
        return ShieldDecorationRecipe.class;
    }
}

