/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.brewing.DefaultBrewingDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@Environment(value=EnvType.CLIENT)
public class DefaultBrewingCategory
implements DisplayCategory<DefaultBrewingDisplay> {
    public CategoryIdentifier<? extends DefaultBrewingDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.BREWING;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Blocks.BREWING_STAND);
    }

    public Component getTitle() {
        return Component.translatable((String)"category.rei.brewing");
    }

    public List<Widget> setupDisplay(DefaultBrewingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 52, bounds.getCenterY() - 29);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            ResourceLocation texture = REIRuntime.getInstance().getDefaultDisplayTexture();
            graphics.blit(RenderPipelines.GUI_TEXTURED, texture, startPoint.x, startPoint.y, 0.0f, 108.0f, 103, 59, 256, 256);
            int width = Mth.ceil((double)((double)System.currentTimeMillis() / 250.0 % 18.0));
            graphics.blit(RenderPipelines.GUI_TEXTURED, texture, startPoint.x + 44, startPoint.y + 28, 103.0f, 163.0f, width, 4, 256, 256);
        }));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 1, startPoint.y + 1)).entry(EntryStacks.of((ItemLike)Items.BLAZE_POWDER)).disableBackground().markInput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 40, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(0)).disableBackground().markInput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 63, startPoint.y + 1)).entries((Collection)display.getInputEntries().get(1)).disableBackground().markInput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 40, startPoint.y + 35)).entries(display.getOutput(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 63, startPoint.y + 42)).entries(display.getOutput(1)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 86, startPoint.y + 35)).entries(display.getOutput(2)).disableBackground().markOutput());
        return widgets;
    }
}

