/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class DefaultShapelessDisplay
extends DefaultCraftingDisplay {
    public static final DisplaySerializer<DefaultCraftingDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)Identifier.CODEC.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation)).apply((Applicative)instance, DefaultCustomShapelessDisplay::new)), (StreamCodec)StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Identifier.STREAM_CODEC), BasicDisplay::getDisplayLocation, DefaultCustomShapelessDisplay::new));

    public DefaultShapelessDisplay(RecipeHolder<ShapelessRecipe> recipe) {
        super(CollectionUtils.map((Collection)((ShapelessRecipe)recipe.value()).placementInfo().ingredients(), EntryIngredients::ofIngredient), List.of(EntryIngredients.of((ItemStack)((ShapelessRecipe)recipe.value()).result)), Optional.of(recipe.id().identifier()));
    }

    public int getWidth() {
        return this.getInputEntries().size() > 4 ? 3 : 2;
    }

    public int getHeight() {
        return this.getInputEntries().size() > 4 ? 3 : 2;
    }

    public int getInputWidth(int craftingWidth, int craftingHeight) {
        return craftingWidth * craftingHeight <= this.getInputEntries().size() ? craftingWidth : Math.min(this.getInputEntries().size(), 3);
    }

    public int getInputHeight(int craftingWidth, int craftingHeight) {
        return (int)Math.ceil((double)this.getInputEntries().size() / (double)this.getInputWidth(craftingWidth, craftingHeight));
    }

    @Override
    public boolean isShapeless() {
        return true;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

