/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultFuelDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DefaultFuelCategory
implements DisplayCategory<DefaultFuelDisplay> {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    public CategoryIdentifier<? extends DefaultFuelDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.FUEL;
    }

    public Component getTitle() {
        return Component.translatable((String)"category.rei.fuel");
    }

    public int getDisplayHeight() {
        return 49;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Items.COAL);
    }

    public List<Widget> setupDisplay(DefaultFuelDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 17);
        String burnItems = DECIMAL_FORMAT.format((double)display.getFuelTime() / 200.0);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + 26, bounds.getMaxY() - 15), (Component)Component.translatable((String)"category.rei.fuel.time.items", (Object[])new Object[]{burnItems})).color(-12566464, -4473925).noShadow().leftAligned());
        widgets.add(Widgets.createBurningFire((Point)new Point(bounds.x + 6, startPoint.y + 1)).animationDurationTicks((double)display.getFuelTime()));
        widgets.add(Widgets.createSlot((Point)new Point(bounds.x + 6, startPoint.y + 18)).entries((Collection)display.getInputEntries().get(0)).markInput());
        return widgets;
    }

    public DisplayRenderer getDisplayRenderer(DefaultFuelDisplay display) {
        final Slot slot = Widgets.createSlot((Point)new Point(0, 0)).entries((Collection)display.getInputEntries().get(0)).disableBackground().disableHighlight();
        final String burnItems = DECIMAL_FORMAT.format((double)display.getFuelTime() / 200.0);
        return new DisplayRenderer(this){
            private Component text;
            {
                this.text = Component.translatable((String)"category.rei.fuel.time_short.items", (Object[])new Object[]{burnItems});
            }

            public int getHeight() {
                return 22;
            }

            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                if (slot.containsMouse(context.getPoint())) {
                    return slot.getCurrentTooltip(context);
                }
                return null;
            }

            public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                slot.getBounds().setLocation(bounds.x + 4, bounds.y + 2);
                slot.render(graphics, mouseX, mouseY, delta);
                graphics.drawString(Minecraft.getInstance().font, this.text.getVisualOrderText(), bounds.x + 25, bounds.y + 8, -1);
            }
        };
    }
}

