/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;

@Environment(value=EnvType.CLIENT)
public class DefaultCompostingCategory
implements DisplayCategory<DefaultCompostingDisplay> {
    public CategoryIdentifier<? extends DefaultCompostingDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.COMPOSTING;
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Blocks.COMPOSTER);
    }

    public Component getTitle() {
        return Component.translatable((String)"category.rei.composting");
    }

    public DisplayRenderer getDisplayRenderer(final DefaultCompostingDisplay display) {
        return new DisplayRenderer(this){
            private Component text;
            {
                this.text = Component.translatable((String)"text.rei.composting.page", (Object[])new Object[]{display.getPage() + 1});
            }

            public int getHeight() {
                Objects.requireNonNull(Minecraft.getInstance().font);
                return 10 + 9;
            }

            public void render(GuiGraphics graphics, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                graphics.drawString(Minecraft.getInstance().font, this.text.getVisualOrderText(), rectangle.x + 5, rectangle.y + 6, -1, false);
            }
        };
    }

    public List<Widget> setupDisplay(DefaultCompostingDisplay display, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        Point startingPoint = new Point(bounds.x + bounds.width - 55, bounds.y + 110);
        ArrayList stacks = new ArrayList(display.getInputEntries());
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        int i = 0;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 7; ++x) {
                ItemStack firstStack;
                float chance;
                EntryIngredient entryIngredient;
                EntryIngredient entryIngredient2 = entryIngredient = stacks.size() > i ? (EntryIngredient)stacks.get(i) : EntryIngredient.empty();
                if (!entryIngredient.isEmpty() && ((EntryStack)entryIngredient.get(0)).getType() == VanillaEntryTypes.ITEM && (chance = ComposterBlock.COMPOSTABLES.getFloat((Object)(firstStack = (ItemStack)((EntryStack)entryIngredient.get(0)).castValue()).getItem())) > 0.0f) {
                    entryIngredient = entryIngredient.map(stack -> stack.copy().tooltip(new Component[]{Component.translatable((String)"text.rei.composting.chance", (Object[])new Object[]{Mth.clamp((int)Mth.floor((float)(chance * 100.0f)), (int)0, (int)100)}).withStyle(ChatFormatting.YELLOW)}));
                }
                widgets.add(Widgets.createSlot((Point)new Point(bounds.getCenterX() - 72 + 9 + x * 18, bounds.y + 12 + y * 18)).entries((Collection)entryIngredient).markInput());
                ++i;
            }
        }
        widgets.add(Widgets.createArrow((Point)new Point(startingPoint.x - 1 - 5, startingPoint.y + 7 - 5)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startingPoint.x + 33 - 5, startingPoint.y + 8 - 5)));
        widgets.add(Widgets.createSlot((Point)new Point(startingPoint.x + 33 - 5, startingPoint.y + 8 - 5)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        return widgets;
    }

    public int getDisplayHeight() {
        return 140;
    }

    public int getFixedDisplaysPerPage() {
        return 1;
    }
}

