/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WeatherFavoriteEntry
extends FavoriteEntry {
    public static final class_2960 ID = class_2960.method_60655((String)"roughlyenoughitems", (String)"weather");
    public static final String TRANSLATION_KEY = "favorite.section.weather";
    private static final class_2960 CHEST_GUI_TEXTURE = class_2960.method_60655((String)"roughlyenoughitems", (String)"textures/gui/recipecontainer.png");
    public static final String KEY = "weather";
    @Nullable
    private final Weather weather;

    public WeatherFavoriteEntry(@Nullable Weather weather) {
        this.weather = weather;
    }

    public boolean isInvalid() {
        return false;
    }

    public Renderer getRenderer(boolean showcase) {
        if (this.weather == null) {
            List renderers = IntStream.range(0, 3).mapToObj(WeatherFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(this, showcase, renderers, () -> WeatherFavoriteEntry.getCurrentWeather().getId()){

                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create((Point)context.getPoint(), (class_2561[])new class_2561[]{class_2561.method_43471((String)"text.rei.weather_button.tooltip.dropdown")});
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                        return false;
                    }
                    return this.hashCode() == o.hashCode();
                }

                public int hashCode() {
                    return Objects.hash(((Object)((Object)this)).getClass(), this.showcase);
                }
            };
        }
        return WeatherFavoriteEntry.getRenderer(this.weather.getId());
    }

    private static Weather getCurrentWeather() {
        class_638 world = class_310.method_1551().field_1687;
        if (world.method_8546()) {
            return Weather.THUNDER;
        }
        if (world.method_28104().method_156()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private static Renderer getRenderer(int id) {
        final Weather weather = Weather.byId(id);
        return new Renderer(){

            public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color;
                int n = color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                if (bounds.width > 4 && bounds.height > 4) {
                    graphics.method_51448().pushMatrix();
                    graphics.method_51448().translate((float)bounds.getCenterX(), (float)bounds.getCenterY());
                    graphics.method_51448().scale((float)bounds.getWidth() / 18.0f, (float)bounds.getHeight() / 18.0f);
                    this.renderWeatherIcon(graphics, weather, 0, 0, color);
                    graphics.method_51448().popMatrix();
                }
            }

            private void renderWeatherIcon(class_332 graphics, Weather type, int centerX, int centerY, int color) {
                graphics.method_25290(class_10799.field_56883, CHEST_GUI_TEXTURE, centerX - 7, centerY - 7, (float)(type.getId() * 14), 14.0f, 14, 14, 256, 256);
            }

            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                return Tooltip.create((Point)context.getPoint(), (class_2561[])new class_2561[]{class_2561.method_43469((String)"text.rei.weather_button.tooltip.entry", (Object[])new Object[]{class_2561.method_43471((String)weather.getTranslateKey())})});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.getClass(), false, weather});
            }
        };
    }

    public boolean doAction(class_11909 event) {
        if (event.method_74245() == 0) {
            if (this.weather != null) {
                class_310.method_1551().field_1724.field_3944.method_45730(StringUtils.removeStart((String)ConfigObject.getInstance().getWeatherCommand().replaceAll("\\{weather}", this.weather.name().toLowerCase(Locale.ROOT)), (String)"/"));
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
            return true;
        }
        return false;
    }

    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (this.weather == null) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.map((Object[])Weather.values(), WeatherMenuEntry::new);
    }

    public long hashIgnoreAmount() {
        return this.weather == null ? 31290831290L : (long)this.weather.ordinal();
    }

    public FavoriteEntry copy() {
        return this;
    }

    public class_2960 getType() {
        return ID;
    }

    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof WeatherFavoriteEntry)) {
            return false;
        }
        WeatherFavoriteEntry that = (WeatherFavoriteEntry)other;
        return Objects.equals((Object)this.weather, (Object)that.weather);
    }

    @ApiStatus.Internal
    public static enum Weather {
        CLEAR(0, "text.rei.weather.clear"),
        RAIN(1, "text.rei.weather.rain"),
        THUNDER(2, "text.rei.weather.thunder");

        private final int id;
        private final String translateKey;

        private Weather(int id, String translateKey) {
            this.id = id;
            this.translateKey = translateKey;
        }

        public static Weather byId(int id) {
            return Weather.byId(id, CLEAR);
        }

        public static Weather byId(int id, Weather defaultWeather) {
            for (Weather weather : Weather.values()) {
                if (weather.id != id) continue;
                return weather;
            }
            return defaultWeather;
        }

        public int getId() {
            return this.id;
        }

        public String getTranslateKey() {
            return this.translateKey;
        }
    }

    public static class WeatherMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final Weather weather;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public WeatherMenuEntry(Weather weather) {
            this.text = class_1074.method_4662((String)weather.getTranslateKey(), (Object[])new Object[0]);
            this.weather = weather;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.method_1727(this.text));
            }
            return this.textWidth;
        }

        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        public int getEntryHeight() {
            return 12;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            if (this.selected) {
                graphics.method_25294(this.x, this.y, this.x + this.width, this.y + 12, -12237499);
            }
            if (this.selected && this.containsMouse) {
                REIRuntime.getInstance().queueTooltip(Tooltip.create((class_2561[])new class_2561[]{class_2561.method_43469((String)"text.rei.weather_button.tooltip.entry", (Object[])new Object[]{this.text})}));
            }
            graphics.method_51433(this.font, this.text, this.x + 2, this.y + 2, this.selected ? 0xFFFFFF : 0x888888, false);
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            class_310.method_1551().field_1724.field_3944.method_45730(StringUtils.removeStart((String)ConfigObject.getInstance().getWeatherCommand().replaceAll("\\{weather}", this.weather.name().toLowerCase(Locale.ROOT)), (String)"/"));
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.closeMenu();
            return true;
        }

        public boolean containsMouse(double mouseX, double mouseY) {
            return this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12);
        }
    }

    public static enum Type implements FavoriteEntryType<WeatherFavoriteEntry>
    {
        INSTANCE;


        public DataResult<WeatherFavoriteEntry> read(class_2487 object) {
            String stringValue = object.method_68564(WeatherFavoriteEntry.KEY, "NOT_SET");
            Weather weather = stringValue.equals("NOT_SET") ? null : Weather.valueOf(stringValue);
            return DataResult.success((Object)((Object)new WeatherFavoriteEntry(weather)), (Lifecycle)Lifecycle.stable());
        }

        public DataResult<WeatherFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create WeatherFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof Weather)) {
                return DataResult.error(() -> "Creation of WeatherFavoriteEntry from args expected Weather as the first argument!");
            }
            Weather weather = (Weather)((Object)object);
            return DataResult.success((Object)((Object)new WeatherFavoriteEntry(weather)), (Lifecycle)Lifecycle.stable());
        }

        public class_2487 save(WeatherFavoriteEntry entry, class_2487 tag) {
            tag.method_10582(WeatherFavoriteEntry.KEY, entry.weather == null ? "NOT_SET" : entry.weather.name());
            return tag;
        }
    }
}

