/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.common.displays.tag;

import dev.architectury.fluid.FluidStack;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@ApiStatus.Experimental
public class DefaultTagDisplay<S, T> implements Display {
    private final class_6862<S> key;
    private final Function<class_6880<S>, EntryStack<T>> mapper;
    private final List<EntryIngredient> ingredients;
    
    public DefaultTagDisplay(class_6862<S> key, Function<class_6880<S>, EntryStack<T>> mapper) {
        this.key = key;
        this.mapper = mapper;
        this.ingredients = CollectionUtils.map(EntryIngredients.ofTag(BasicDisplay.registryAccess(), key, mapper), EntryIngredient::of);
    }
    
    public static DefaultTagDisplay<class_1935, class_1799> ofItems(class_6862<class_1935> key) {
        return new DefaultTagDisplay<>(key, DefaultTagDisplay::extractItem);
    }
    
    public static DefaultTagDisplay<class_3611, FluidStack> ofFluids(class_6862<class_3611> key) {
        return new DefaultTagDisplay<>(key, DefaultTagDisplay::extractFluid);
    }
    
    private static EntryStack<class_1799> extractItem(class_6880<class_1935> holder) {
        return EntryStacks.of(holder.comp_349());
    }
    
    private static EntryStack<FluidStack> extractFluid(class_6880<class_3611> holder) {
        return EntryStacks.of(holder.comp_349());
    }
    
    @Override
    public List<EntryIngredient> getInputEntries() {
        return this.ingredients;
    }
    
    @Override
    public List<EntryIngredient> getOutputEntries() {
        return this.ingredients;
    }
    
    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.TAG;
    }
    
    @Override
    public Optional<class_2960> getDisplayLocation() {
        return Optional.of(key.comp_327());
    }
    
    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return null;
    }
    
    public class_6862<S> getKey() {
        return key;
    }
    
    public Function<class_6880<S>, EntryStack<T>> getMapper() {
        return mapper;
    }
}
