/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.api.client.gui.widgets;

import me.shedaniel.math.Rectangle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;

public class DelegateWidget extends WidgetWithBounds {
    private static final Rectangle EMPTY = new Rectangle();
    protected final Widget widget;
    
    public DelegateWidget(Widget widget) {
        this.widget = widget;
    }
    
    protected Widget delegate() {
        return widget;
    }
    
    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        delegate().render(graphics, mouseX, mouseY, delta);
    }
    
    @Override
    public List<? extends GuiEventListener> children() {
        return Collections.singletonList(delegate());
    }
    
    @Override
    public Rectangle getBounds() {
        return delegate() instanceof WidgetWithBounds withBounds ? withBounds.getBounds() : EMPTY;
    }
    
    @Nullable
    @Override
    public GuiEventListener getFocused() {
        return delegate();
    }
    
    @Override
    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        Widget delegate = delegate();
        if (guiEventListener == delegate) {
            super.setFocused(delegate);
        } else {
            delegate.setFocused(guiEventListener);
        }
    }
    
    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return delegate().containsMouse(mouseX, mouseY);
    }
    
    @Override
    public boolean isDragging() {
        return true;
    }
    
    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        return delegate().mouseScrolled(mouseX, mouseY, amountX, amountY);
    }
    
    @Override
    public boolean keyPressed(KeyEvent event) {
        return delegate().keyPressed(event);
    }
    
    @Override
    public boolean keyReleased(KeyEvent event) {
        return delegate().keyReleased(event);
    }
    
    @Override
    public boolean charTyped(CharacterEvent event) {
        return delegate().charTyped(event);
    }
    
    @Override
    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        return delegate().mouseDragged(event, deltaX, deltaY);
    }
    
    @Override
    public boolean mouseReleased(MouseButtonEvent event) {
        this.setDragging(false);
        return delegate().mouseReleased(event);
    }
    
    @Override
    public double getZRenderingPriority() {
        return delegate().getZRenderingPriority();
    }
}
