/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.screen;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.impl.ClientInternals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
@Environment(value=EnvType.CLIENT)
public interface ClickArea<T extends Screen> {
    public Result handle(ClickAreaContext<T> var1);

    @ApiStatus.NonExtendable
    public static interface Result {
        public static Result success() {
            return ClientInternals.createClickAreaHandlerResult(true);
        }

        public static Result fail() {
            return ClientInternals.createClickAreaHandlerResult(false);
        }

        @ApiStatus.Experimental
        public Result executor(BooleanSupplier var1);

        public Result category(CategoryIdentifier<?> var1);

        default public Result categories(Iterable<? extends CategoryIdentifier<?>> categories) {
            for (CategoryIdentifier<?> category : categories) {
                this.category(category);
            }
            return this;
        }

        @ApiStatus.Experimental
        public Result tooltip(Supplier<Component @Nullable []> var1);

        public boolean isSuccessful();

        @ApiStatus.Experimental
        public boolean execute();

        @ApiStatus.Experimental
        public Component @Nullable [] getTooltips();

        public Stream<CategoryIdentifier<?>> getCategories();
    }

    @ApiStatus.NonExtendable
    public static interface ClickAreaContext<T extends Screen> {
        public T getScreen();

        public Point getMousePosition();
    }
}

