/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.favorites;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.entry.region.RegionEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.ClientInternals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class FavoriteEntry
implements RegionEntry<FavoriteEntry> {
    public static final String TYPE_KEY = "type";
    private final UUID uuid = UUID.randomUUID();

    public static FavoriteEntry delegate(Supplier<FavoriteEntry> supplier, @Nullable Supplier<CompoundTag> toJson) {
        return FavoriteEntry.delegateResult(() -> DataResult.success((Object)((FavoriteEntry)supplier.get()), (Lifecycle)Lifecycle.stable()), toJson);
    }

    public static FavoriteEntry delegateResult(Supplier<DataResult<FavoriteEntry>> supplier, @Nullable Supplier<CompoundTag> toJson) {
        return ClientInternals.delegateFavoriteEntry(supplier, toJson);
    }

    @Nullable
    public static FavoriteEntry read(CompoundTag object) {
        return FavoriteEntry.readResult(object).result().orElse(null);
    }

    public static DataResult<FavoriteEntry> readResult(CompoundTag object) {
        return ClientInternals.favoriteEntryFromJson(object);
    }

    public static FavoriteEntry readDelegated(CompoundTag object) {
        CompoundTag copy = object.copy();
        return FavoriteEntry.delegateResult(() -> FavoriteEntry.readResult(object), () -> copy);
    }

    public static FavoriteEntry fromEntryStack(EntryStack<?> stack) {
        return FavoriteEntry.delegateResult(() -> FavoriteEntryType.registry().get(FavoriteEntryType.ENTRY_STACK).fromArgs(stack), null);
    }

    @ApiStatus.Experimental
    public static FavoriteEntry fromDisplay(Display display) {
        return FavoriteEntry.delegateResult(() -> FavoriteEntryType.registry().get(FavoriteEntryType.DISPLAY).fromArgs(display), null);
    }

    @Override
    public boolean isEntryInvalid() {
        return this.isInvalid();
    }

    public CompoundTag save(CompoundTag tag) {
        tag.putString(TYPE_KEY, this.getType().toString());
        return Objects.requireNonNull(Objects.requireNonNull(FavoriteEntryType.registry().get(this.getType())).save(this, tag));
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    public abstract boolean isInvalid();

    public abstract Renderer getRenderer(boolean var1);

    @Override
    public abstract boolean doAction(MouseButtonEvent var1);

    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        return Optional.empty();
    }

    public abstract long hashIgnoreAmount();

    @Override
    public abstract FavoriteEntry copy();

    public abstract Identifier getType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FavoriteEntry)) {
            return false;
        }
        FavoriteEntry that = (FavoriteEntry)o;
        try {
            FavoriteEntry unwrapped = this.getUnwrapped();
            FavoriteEntry thatUnwrapped = that.getUnwrapped();
            return unwrapped == thatUnwrapped || unwrapped.isSame(thatUnwrapped);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + Long.hashCode(this.hashIgnoreAmount());
        return result;
    }

    public abstract boolean isSame(FavoriteEntry var1);

    public FavoriteEntry getUnwrapped() {
        return this;
    }

    @Override
    public EntryStack<?> toStack() {
        return ClientEntryStacks.of(this.getRenderer(false));
    }

    @Override
    public FavoriteEntry asFavorite() {
        return this.copy();
    }
}

