/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.favorites;

import java.util.List;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.Renderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Util;

@Environment(value=EnvType.CLIENT)
public class CompoundFavoriteRenderer
implements Renderer {
    protected NumberAnimator<Double> offset = ValueAnimator.ofDouble();
    protected Rectangle scissorArea = new Rectangle();
    protected long nextSwitch = -1L;
    protected IntFunction<Renderer> renderers;
    protected int count;
    protected boolean showcase;
    protected IntSupplier supplier;

    public CompoundFavoriteRenderer(List<Renderer> renderers) {
        this(true, renderers, null);
    }

    public CompoundFavoriteRenderer(List<Renderer> renderers, IntSupplier supplier) {
        this(false, renderers, supplier);
    }

    protected CompoundFavoriteRenderer(boolean showcase, List<Renderer> renderers, IntSupplier supplier) {
        this(showcase, renderers.size(), renderers::get, supplier);
    }

    public CompoundFavoriteRenderer(int count, IntFunction<Renderer> renderers) {
        this(true, count, renderers, null);
    }

    public CompoundFavoriteRenderer(int count, IntFunction<Renderer> renderers, IntSupplier supplier) {
        this(false, count, renderers, supplier);
    }

    public CompoundFavoriteRenderer(boolean showcase, int count, IntFunction<Renderer> renderers, IntSupplier supplier) {
        this.count = count;
        this.showcase = showcase;
        this.renderers = renderers;
        this.supplier = supplier;
    }

    @Override
    public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        this.updateAnimator(delta);
        graphics.enableScissor(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY());
        graphics.pose().pushMatrix();
        graphics.pose().translate(0.0f, this.offset.floatValue() * (float)(-bounds.getHeight()));
        for (int i = 0; i < this.count; ++i) {
            this.renderers.apply(i).render(graphics, bounds, mouseX, mouseY, delta);
            graphics.pose().translate(0.0f, (float)bounds.height);
        }
        graphics.pose().popMatrix();
        graphics.disableScissor();
    }

    private void updateAnimator(float delta) {
        this.offset.update((double)delta);
        if (this.showcase) {
            if (this.nextSwitch == -1L) {
                this.nextSwitch = Util.getMillis();
            }
            if (Util.getMillis() - this.nextSwitch > 1000L) {
                this.nextSwitch = Util.getMillis();
                this.offset.setTo((((Double)this.offset.target()).intValue() + 1) % this.count, ConfigObject.getInstance().isReducedMotion() ? 0L : 500L);
            }
        } else {
            this.offset.setTo(this.supplier.getAsInt() % this.count, ConfigObject.getInstance().isReducedMotion() ? 0L : 500L);
        }
    }
}

