/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.common;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.GameInstance;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

import java.lang.ref.WeakReference;
import java.util.function.Supplier;

@ApiStatus.Internal
public final class InternalRegistryAccess implements Supplier<class_5455> {
    private static final InternalRegistryAccess INSTANCE = new InternalRegistryAccess();
    private WeakReference<class_5455> registryAccess;
    private boolean warned;
    
    public static InternalRegistryAccess getInstance() {
        return INSTANCE;
    }
    
    @Override
    public class_5455 get() {
        class_5455 access = this.registryAccess == null ? null : this.registryAccess.get();
        if (access != null) {
            return access;
        }
        
        if (Platform.getEnvironment() == Env.CLIENT) {
            access = getFromClient();
        } else if (GameInstance.getServer() != null) {
            access = GameInstance.getServer().method_30611();
        }
        
        if (access == null && !this.warned) {
            this.warned = true;
            
            new NullPointerException("Cannot get registry access!").printStackTrace();
            InternalLogger.getInstance().warn("Cannot get registry access!");
            return class_5455.method_40302(class_7923.field_41167);
        }
        
        return access;
    }
    
    @Environment(EnvType.CLIENT)
    private static class_5455 getFromClient() {
        if (class_310.method_1551().field_1687 != null) {
            return class_310.method_1551().field_1687.method_30349();
        } else if (class_310.method_1551().method_1562() != null) {
            return class_310.method_1551().method_1562().method_29091();
        } else if (class_310.method_1551().field_1761 != null) {
            // Sometimes the packet is sent way too fast and is between the connection and the level, better safe than sorry
            return class_310.method_1551().field_1761.field_3720.method_29091();
        }
        
        return null;
    }
}
