/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.transfer;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class ItemRecipeFinder {
    private final Interner<ItemKey> keys = Interners.newWeakInterner();
    private final RecipeFinder<ItemKey> finder = new RecipeFinder();

    public boolean contains(class_1799 item) {
        return this.finder.contains(this.ofKey(item));
    }

    boolean containsAtLeast(class_1799 object, int i) {
        return this.finder.containsAtLeast(this.ofKey(object), i);
    }

    public void take(class_1799 item, int amount) {
        this.finder.take(this.ofKey(item), amount);
    }

    public void put(class_1799 item, int amount) {
        this.finder.put(this.ofKey(item), amount);
    }

    public void addNormalItem(class_1799 itemStack) {
        if (class_1661.method_61495((class_1799)itemStack)) {
            this.addItem(itemStack);
        }
    }

    public void addItem(class_1799 itemStack) {
        this.addItem(itemStack, itemStack.method_7914());
    }

    public void addItem(class_1799 itemStack, int i) {
        if (!itemStack.method_7960()) {
            int j = Math.min(i, itemStack.method_7947());
            this.finder.put(this.ofKey(itemStack), j);
        }
    }

    public boolean findRecipe(List<List<class_1799>> list, int maxCrafts, @Nullable Consumer<class_1799> output) {
        return this.finder.findRecipe(CollectionUtils.map(list, this::ofKeys), maxCrafts, (T itemKey) -> {
            if (output != null) {
                output.accept(new class_1799(itemKey.item(), 1, itemKey.patch()));
            }
        });
    }

    public int countRecipeCrafts(List<List<class_1799>> list, int maxCrafts, @Nullable Consumer<class_1799> output) {
        return this.finder.countRecipeCrafts(CollectionUtils.map(list, this::ofKeys), maxCrafts, (T itemKey) -> {
            if (output != null) {
                output.accept(new class_1799(itemKey.item(), 1, itemKey.patch()));
            }
        });
    }

    private ItemKey ofKey(class_1799 itemStack) {
        return (ItemKey)this.keys.intern((Object)new ItemKey((class_6880<class_1792>)itemStack.method_41409(), itemStack.method_57380()));
    }

    private RecipeFinder.Ingredient<ItemKey> ofKeys(List<class_1799> itemStack) {
        return new RecipeFinder.Ingredient<ItemKey>(CollectionUtils.map(itemStack, this::ofKey));
    }

    private record ItemKey(class_6880<class_1792> item, class_9326 patch) {
    }
}

