/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.favorites;

import java.util.List;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.Renderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class CompoundFavoriteRenderer
implements Renderer {
    protected NumberAnimator<Double> offset = ValueAnimator.ofDouble();
    protected Rectangle scissorArea = new Rectangle();
    protected long nextSwitch = -1L;
    protected IntFunction<Renderer> renderers;
    protected int count;
    protected boolean showcase;
    protected IntSupplier supplier;

    public CompoundFavoriteRenderer(List<Renderer> renderers) {
        this(true, renderers, null);
    }

    public CompoundFavoriteRenderer(List<Renderer> renderers, IntSupplier supplier) {
        this(false, renderers, supplier);
    }

    protected CompoundFavoriteRenderer(boolean showcase, List<Renderer> renderers, IntSupplier supplier) {
        this(showcase, renderers.size(), renderers::get, supplier);
    }

    public CompoundFavoriteRenderer(int count, IntFunction<Renderer> renderers) {
        this(true, count, renderers, null);
    }

    public CompoundFavoriteRenderer(int count, IntFunction<Renderer> renderers, IntSupplier supplier) {
        this(false, count, renderers, supplier);
    }

    public CompoundFavoriteRenderer(boolean showcase, int count, IntFunction<Renderer> renderers, IntSupplier supplier) {
        this.count = count;
        this.showcase = showcase;
        this.renderers = renderers;
        this.supplier = supplier;
    }

    @Override
    public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        this.updateAnimator(delta);
        graphics.method_44379(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY());
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, this.offset.floatValue() * (float)(-bounds.getHeight()), 0.0f);
        for (int i = 0; i < this.count; ++i) {
            this.renderers.apply(i).render(graphics, bounds, mouseX, mouseY, delta);
            graphics.method_51448().method_46416(0.0f, (float)bounds.height, 0.0f);
        }
        graphics.method_51448().method_22909();
        graphics.method_44380();
    }

    private void updateAnimator(float delta) {
        this.offset.update((double)delta);
        if (this.showcase) {
            if (this.nextSwitch == -1L) {
                this.nextSwitch = class_156.method_658();
            }
            if (class_156.method_658() - this.nextSwitch > 1000L) {
                this.nextSwitch = class_156.method_658();
                this.offset.setTo((((Double)this.offset.target()).intValue() + 1) % this.count, ConfigObject.getInstance().isReducedMotion() ? 0L : 500L);
            }
        } else {
            this.offset.setTo(this.supplier.getAsInt() % this.count, ConfigObject.getInstance().isReducedMotion() ? 0L : 500L);
        }
    }
}

