/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.api.common.transfer.info.stack;

import net.minecraft.class_1657;
import net.minecraft.class_1799;

/**
 * Simple implementation of {@link SlotAccessor} that wraps around a slot in player's inventory.
 */
public class PlayerInventorySlotAccessor implements SlotAccessor {
    protected class_1657 player;
    protected int index;
    
    public PlayerInventorySlotAccessor(class_1657 player, int index) {
        this.player = player;
        this.index = index;
    }
    
    @Override
    public class_1799 getItemStack() {
        return player.method_31548().method_5438(index);
    }
    
    @Override
    public void setItemStack(class_1799 stack) {
        this.player.method_31548().method_5447(index, stack);
    }
    
    @Override
    public class_1799 takeStack(int amount) {
        return this.player.method_31548().method_5434(index, amount);
    }
    
    public int getIndex() {
        return index;
    }
}
