/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.api.client.favorites;

import com.mojang.serialization.DataResult;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.Reloadable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.List;

@Environment(EnvType.CLIENT)
public interface FavoriteEntryType<T extends FavoriteEntry> {
    /**
     * A builtin type of favorites, wrapping a {@link EntryStack}.
     */
    class_2960 ENTRY_STACK = class_2960.method_60655("roughlyenoughitems", "entry_stack");
    /**
     * A builtin type of favorites, wrapping a {@link Display}.
     */
    @ApiStatus.Experimental
    class_2960 DISPLAY = class_2960.method_60655("roughlyenoughitems", "display");
    
    static Registry registry() {
        return PluginManager.getClientInstance().get(FavoriteEntryType.Registry.class);
    }
    
    DataResult<T> read(class_2487 object);
    
    DataResult<T> fromArgs(Object... args);
    
    class_2487 save(T entry, class_2487 tag);
    
    @ApiStatus.NonExtendable
    interface Registry extends Reloadable<REIClientPlugin> {
        void register(class_2960 id, FavoriteEntryType<?> type);
        
        @Nullable <A extends FavoriteEntry> FavoriteEntryType<A> get(class_2960 id);
        
        @Nullable
        class_2960 getId(FavoriteEntryType<?> type);
        
        Section getOrCrateSection(class_2561 text);
        
        Iterable<Section> sections();
        
        /**
         * @deprecated {@link FavoriteEntryType.Section#add(boolean, FavoriteEntry...)}
         */
        @Deprecated(forRemoval = true)
        <A extends FavoriteEntry> void registerSystemFavorites(SystemFavoriteEntryProvider<A> provider);
    }
    
    @ApiStatus.NonExtendable
    interface Section {
        default void add(FavoriteEntry... entries) {
            add(false, entries);
        }
    
        @ApiStatus.Experimental
        void add(boolean defaultFavorited, FavoriteEntry... entries);
        
        class_2561 getText();
        
        List<FavoriteEntry> getEntries();
        
        @ApiStatus.Experimental
        List<FavoriteEntry> getDefaultEntries();
    }
}
