/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.mojmap;

import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.spec.MappingsSpec;
import net.fabricmc.loom.configuration.providers.mappings.mojmap.MojangMappingLayer;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.download.DownloadException;

public record MojangMappingsSpec(SilenceLicenseOption silenceLicense, boolean nameSyntheticMembers) implements MappingsSpec<MojangMappingLayer>
{
    private static final String MANIFEST_CLIENT_MAPPINGS = "client_mappings";
    private static final String MANIFEST_SERVER_MAPPINGS = "server_mappings";

    public MojangMappingsSpec(SilenceLicenseSupplier supplier, boolean nameSyntheticMembers) {
        this(new SilenceLicenseOption(supplier), nameSyntheticMembers);
    }

    public MojangMappingsSpec(boolean nameSyntheticMembers) {
        this(() -> false, nameSyntheticMembers);
    }

    @Override
    public MojangMappingLayer createLayer(MappingContext context) {
        MinecraftVersionMeta versionInfo = context.minecraftProvider().getVersionInfo();
        MinecraftVersionMeta.Download clientDownload = versionInfo.download(MANIFEST_CLIENT_MAPPINGS);
        MinecraftVersionMeta.Download serverDownload = versionInfo.download(MANIFEST_SERVER_MAPPINGS);
        if (clientDownload == null) {
            throw new RuntimeException("Failed to find official mojang mappings for " + context.minecraftVersion());
        }
        Path clientMappings = context.workingDirectory("mojang").resolve("client.txt");
        Path serverMappings = context.workingDirectory("mojang").resolve("server.txt");
        try {
            context.download(clientDownload.url()).sha1(clientDownload.sha1()).downloadPath(clientMappings);
            context.download(serverDownload.url()).sha1(serverDownload.sha1()).downloadPath(serverMappings);
        }
        catch (DownloadException e) {
            throw new UncheckedIOException("Failed to download mappings", e);
        }
        return new MojangMappingLayer(context.minecraftVersion(), clientMappings, serverMappings, this.nameSyntheticMembers(), context.hasProperty("fabric.loom.dropNonIntermediateRootMethods"), context.isUsingIntermediateMappings() ? context.intermediaryTree() : null, context.getLogger(), this.silenceLicense());
    }

    public record SilenceLicenseOption(SilenceLicenseSupplier supplier) {
        public boolean isSilent() {
            return this.supplier.isSilent();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SilenceLicenseOption)) {
                return false;
            }
            SilenceLicenseOption that = (SilenceLicenseOption)o;
            return this.isSilent() == that.isSilent();
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.isSilent());
        }

        @Override
        public String toString() {
            return "" + this.isSilent();
        }
    }

    @FunctionalInterface
    public static interface SilenceLicenseSupplier {
        public boolean isSilent();
    }
}

