/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.dependency;

import java.io.File;
import java.nio.file.Path;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.extension.LoomFiles;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;

public abstract class DependencyProvider {
    private final Project project;
    private final LoomGradleExtension extension;

    public DependencyProvider(Project project) {
        this.project = project;
        this.extension = LoomGradleExtension.get(project);
    }

    public abstract void provide(DependencyInfo var1) throws Exception;

    public abstract String getTargetConfig();

    public Dependency addDependency(Object object, String target) {
        return DependencyProvider.addDependency(this.project, object, target);
    }

    public static Dependency addDependency(Project project, Object object, String target) {
        if (object instanceof File || object instanceof Path) {
            object = project.files(new Object[]{object});
        }
        return project.getDependencies().add(target, object);
    }

    public Project getProject() {
        return this.project;
    }

    public LoomGradleExtension getExtension() {
        return this.extension;
    }

    public LoomFiles getDirectories() {
        return this.getExtension().getFiles();
    }

    public MinecraftProvider getMinecraftProvider() {
        return this.getExtension().getMinecraftProvider();
    }

    public boolean refreshDeps() {
        return this.getExtension().refreshDeps();
    }
}

