/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.api;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class RemapConfigurationSettings
implements Named {
    private final String name;

    @Inject
    public RemapConfigurationSettings(String name) {
        this.name = name;
        this.getSourceSet().finalizeValueOnRead();
        this.getTargetConfigurationName().finalizeValueOnRead();
        this.getClientSourceConfigurationName().finalizeValueOnRead();
        this.getOnCompileClasspath().finalizeValueOnRead();
        this.getOnRuntimeClasspath().finalizeValueOnRead();
        this.getPublishingMode().convention((Object)PublishingMode.NONE).finalizeValueOnRead();
        this.getApplyDependencyTransforms().convention(this.defaultDependencyTransforms()).finalizeValueOnRead();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public abstract Property<SourceSet> getSourceSet();

    public abstract Property<String> getTargetConfigurationName();

    public abstract Property<String> getClientSourceConfigurationName();

    public abstract Property<Boolean> getOnCompileClasspath();

    public abstract Property<Boolean> getOnRuntimeClasspath();

    public abstract Property<PublishingMode> getPublishingMode();

    public abstract Property<Boolean> getApplyDependencyTransforms();

    @Inject
    protected abstract Project getProject();

    @Internal
    @ApiStatus.Internal
    public final String getRemappedConfigurationName() {
        return this.getName() + "Mapped";
    }

    @Internal
    @ApiStatus.Internal
    public final NamedDomainObjectProvider<Configuration> getSourceConfiguration() {
        return this.getConfigurationByName(this.getName());
    }

    @Internal
    private NamedDomainObjectProvider<Configuration> getConfigurationByName(String name) {
        return this.getProject().getConfigurations().named(name);
    }

    private Provider<Boolean> defaultDependencyTransforms() {
        return this.getSourceSet().map(sourceSet -> sourceSet.getName().equals("main") || sourceSet.getName().equals("client"));
    }

    public String toString() {
        return "RemapConfigurationSettings '" + this.getName() + "'";
    }

    public static enum PublishingMode {
        NONE(new String[0]),
        COMPILE_ONLY("apiElements"),
        RUNTIME_ONLY("runtimeElements"),
        COMPILE_AND_RUNTIME("apiElements", "runtimeElements");

        private final Set<String> outgoingConfigurations;

        private PublishingMode(String ... outgoingConfigurations) {
            this.outgoingConfigurations = Set.of(outgoingConfigurations);
        }

        public Set<String> outgoingConfigurations() {
            return this.outgoingConfigurations;
        }
    }
}

