/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.mappings;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.srg.TsrgFileReader;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.jetbrains.annotations.Nullable;

public class MCPReader {
    private final Path intermediaryTinyPath;
    private final Path srgTsrgPath;

    public MCPReader(Path intermediaryTinyPath, Path srgTsrgPath) {
        this.intermediaryTinyPath = intermediaryTinyPath;
        this.srgTsrgPath = srgTsrgPath;
    }

    public MappingTree read(Path mcpJar) throws IOException {
        Map<MemberToken, String> srgTokens = this.readSrg();
        MemoryMappingTree intermediaryTiny = new MemoryMappingTree();
        MappingReader.read((Path)this.intermediaryTinyPath, (MappingFormat)MappingFormat.TINY_2_FILE, (MappingVisitor)intermediaryTiny);
        Map<String, String> intermediaryToMCPMap = this.createIntermediaryToMCPMap((MappingTree)intermediaryTiny, srgTokens);
        HashMap<String, String> intermediaryToDocsMap = new HashMap<String, String>();
        HashMap<String, Map<Integer, String>> intermediaryToParamsMap = new HashMap<String, Map<Integer, String>>();
        try {
            this.injectMcp(mcpJar, intermediaryToMCPMap, intermediaryToDocsMap, intermediaryToParamsMap);
        }
        catch (CsvValidationException e) {
            throw new RuntimeException(e);
        }
        this.mergeTokensIntoIntermediary((MappingTree)intermediaryTiny, intermediaryToMCPMap, intermediaryToDocsMap, intermediaryToParamsMap);
        return intermediaryTiny;
    }

    private Map<String, String> createIntermediaryToMCPMap(MappingTree tiny, Map<MemberToken, String> officialToMCP) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (MappingTree.ClassMapping tinyClass : tiny.getClasses()) {
            String classObf = tinyClass.getSrcName();
            String classIntermediary = tinyClass.getDstName(0);
            MemberToken classTokenObf = MemberToken.ofClass(classObf);
            if (officialToMCP.containsKey(classTokenObf)) {
                map.put(classIntermediary, officialToMCP.get(classTokenObf));
            }
            for (MappingTree.FieldMapping tinyField : tinyClass.getFields()) {
                String fieldObf = tinyField.getSrcName();
                String fieldIntermediary = tinyField.getDstName(0);
                MemberToken fieldTokenObf = MemberToken.ofField(classTokenObf, fieldObf);
                if (!officialToMCP.containsKey(fieldTokenObf)) continue;
                map.put(fieldIntermediary, officialToMCP.get(fieldTokenObf));
            }
            for (MappingTree.MethodMapping tinyMethod : tinyClass.getMethods()) {
                String methodObf = tinyMethod.getSrcName();
                String methodIntermediary = tinyMethod.getDstName(0);
                MemberToken methodTokenObf = MemberToken.ofMethod(classTokenObf, methodObf, tinyMethod.getSrcDesc());
                if (!officialToMCP.containsKey(methodTokenObf)) continue;
                map.put(methodIntermediary, officialToMCP.get(methodTokenObf));
            }
        }
        return map;
    }

    private void mergeTokensIntoIntermediary(MappingTree tiny, Map<String, String> intermediaryToMCPMap, Map<String, String> intermediaryToDocsMap, Map<String, Map<Integer, String>> intermediaryToParamsMap) {
        tiny.setDstNamespaces(List.of("intermediary", "named"));
        for (MappingTree.ClassMapping tinyClass : tiny.getClasses()) {
            String docs;
            String classIntermediary = tinyClass.getDstName(0);
            tinyClass.setDstName(intermediaryToMCPMap.getOrDefault(classIntermediary, classIntermediary), 1);
            for (MappingTree.FieldMapping tinyField : tinyClass.getFields()) {
                String fieldIntermediary = tinyField.getDstName(0);
                docs = intermediaryToDocsMap.get(fieldIntermediary);
                tinyField.setDstName(intermediaryToMCPMap.getOrDefault(fieldIntermediary, fieldIntermediary), 1);
                if (docs == null) continue;
                tinyField.setComment(docs);
            }
            for (MappingTree.MethodMapping tinyMethod : tinyClass.getMethods()) {
                Map<Integer, String> params;
                String methodIntermediary = tinyMethod.getDstName(0);
                docs = intermediaryToDocsMap.get(methodIntermediary);
                tinyMethod.setDstName(intermediaryToMCPMap.getOrDefault(methodIntermediary, methodIntermediary), 1);
                if (docs != null) {
                    tinyMethod.setComment(docs);
                }
                if ((params = intermediaryToParamsMap.get(methodIntermediary)) == null) continue;
                for (Map.Entry<Integer, String> entry : params.entrySet()) {
                    int lvIndex = entry.getKey();
                    String paramName = entry.getValue();
                    tinyMethod.addArg((MappingTree.MethodArgMapping)new BasicMethodArg(tinyMethod, lvIndex, paramName));
                }
            }
        }
    }

    private Map<MemberToken, String> readSrg() throws IOException {
        HashMap<MemberToken, String> tokens = new HashMap<MemberToken, String>();
        MemoryMappingTree tree = new MemoryMappingTree();
        try (BufferedReader reader = Files.newBufferedReader(this.srgTsrgPath, StandardCharsets.UTF_8);){
            TsrgFileReader.read((Reader)reader, (String)"obf", (String)"srg", (MappingVisitor)tree);
        }
        int obfIndex = tree.getNamespaceId("obf");
        int srgIndex = tree.getNamespaceId("srg");
        for (MappingTree.ClassMapping classDef : tree.getClasses()) {
            MemberToken ofClass = MemberToken.ofClass(classDef.getName(obfIndex));
            tokens.put(ofClass, classDef.getName(srgIndex));
            for (MappingTree.FieldMapping fieldDef : classDef.getFields()) {
                tokens.put(MemberToken.ofField(ofClass, fieldDef.getName(obfIndex)), fieldDef.getName(srgIndex));
            }
            for (MappingTree.MethodMapping methodDef : classDef.getMethods()) {
                tokens.put(MemberToken.ofMethod(ofClass, methodDef.getName(obfIndex), methodDef.getDesc(obfIndex)), methodDef.getName(srgIndex));
            }
        }
        return tokens;
    }

    private void injectMcp(Path mcpJar, Map<String, String> intermediaryToSrgMap, Map<String, String> intermediaryToDocsMap, Map<String, Map<Integer, String>> intermediaryToParamsMap) throws IOException, CsvValidationException {
        block30: {
            Map<String, List<String>> srgToIntermediary = this.inverseMap(intermediaryToSrgMap);
            HashMap<String, List<String>> simpleSrgToIntermediary = new HashMap<String, List<String>>();
            Pattern methodPattern = Pattern.compile("(func_\\d*)_.*");
            for (Map.Entry<String, List<String>> entry : srgToIntermediary.entrySet()) {
                Matcher matcher = methodPattern.matcher(entry.getKey());
                if (!matcher.matches()) continue;
                simpleSrgToIntermediary.put(matcher.group(1), entry.getValue());
            }
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(mcpJar, false);){
                String docs;
                String[] line;
                Path fields = fs.getPath("fields.csv", new String[0]);
                Path methods = fs.getPath("methods.csv", new String[0]);
                Path params = fs.getPath("params.csv", new String[0]);
                Pattern paramsPattern = Pattern.compile("p_[^\\d]*(\\d+)_(\\d)+_?");
                try (CSVReader reader = new CSVReader((Reader)Files.newBufferedReader(fields, StandardCharsets.UTF_8));){
                    reader.readNext();
                    while ((line = reader.readNext()) != null) {
                        List<String> intermediaryField = srgToIntermediary.get(line[0]);
                        docs = line[3];
                        if (intermediaryField == null) continue;
                        for (String s : intermediaryField) {
                            intermediaryToSrgMap.put(s, line[1]);
                            if (line[3].isBlank()) continue;
                            intermediaryToDocsMap.put(s, docs);
                        }
                    }
                }
                reader = new CSVReader((Reader)Files.newBufferedReader(methods, StandardCharsets.UTF_8));
                try {
                    reader.readNext();
                    while ((line = reader.readNext()) != null) {
                        List<String> intermediaryMethod = srgToIntermediary.get(line[0]);
                        docs = line[3];
                        if (intermediaryMethod == null) continue;
                        for (String s : intermediaryMethod) {
                            intermediaryToSrgMap.put(s, line[1]);
                            if (line[3].isBlank()) continue;
                            intermediaryToDocsMap.put(s, docs);
                        }
                    }
                }
                finally {
                    reader.close();
                }
                if (!Files.exists(params, new LinkOption[0])) break block30;
                reader = new CSVReader((Reader)Files.newBufferedReader(params, StandardCharsets.UTF_8));
                try {
                    reader.readNext();
                    while ((line = reader.readNext()) != null) {
                        Matcher param = paramsPattern.matcher(line[0]);
                        if (!param.matches()) continue;
                        String named = line[1];
                        String srgMethodStartWith = "func_" + param.group(1);
                        int lvIndex = Integer.parseInt(param.group(2));
                        List intermediaryMethod = (List)simpleSrgToIntermediary.get(srgMethodStartWith);
                        if (intermediaryMethod == null) continue;
                        for (String s : intermediaryMethod) {
                            intermediaryToParamsMap.computeIfAbsent(s, s1 -> new HashMap()).put(lvIndex, named);
                        }
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
    }

    private Map<String, List<String>> inverseMap(Map<String, String> intermediaryToMCPMap) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> token : intermediaryToMCPMap.entrySet()) {
            map.computeIfAbsent(token.getValue(), s -> new ArrayList()).add(token.getKey());
        }
        return map;
    }

    private record MemberToken(TokenType type, @Nullable MemberToken owner, String name, @Nullable String descriptor) {
        static MemberToken ofClass(String name) {
            return new MemberToken(TokenType.CLASS, null, name, null);
        }

        static MemberToken ofField(MemberToken owner, String name) {
            return new MemberToken(TokenType.FIELD, owner, name, null);
        }

        static MemberToken ofMethod(MemberToken owner, String name, String descriptor) {
            return new MemberToken(TokenType.METHOD, owner, name, descriptor);
        }
    }

    private record BasicMethodArg(MappingTree.MethodMapping parent, int lvIndex, String name) implements MappingTree.MethodArgMapping
    {
        public MappingTree.MethodMapping getMethod() {
            return this.parent;
        }

        public MappingTree getTree() {
            return this.parent.getTree();
        }

        public int getArgPosition() {
            return -1;
        }

        public int getLvIndex() {
            return this.lvIndex;
        }

        public String getSrcName() {
            return null;
        }

        @Nullable
        public String getDstName(int namespace) {
            return namespace == 1 ? this.name : null;
        }

        @Nullable
        public String getComment() {
            return null;
        }

        public void setArgPosition(int position) {
            throw new UnsupportedOperationException();
        }

        public void setLvIndex(int index) {
            throw new UnsupportedOperationException();
        }

        public void setDstName(String name, int namespace) {
            throw new UnsupportedOperationException();
        }

        public void setComment(String comment) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum TokenType {
        CLASS,
        METHOD,
        FIELD;

    }
}

