/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.dependency;

import dev.architectury.loom.forge.dependency.DependencyProvider;
import dev.architectury.loom.forge.dependency.ForgeProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.util.FileSystemUtil;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;

public class PatchProvider
extends DependencyProvider {
    private final Path projectCacheFolder;
    private Path installerJar;
    @Nullable
    private Path clientPatches;
    @Nullable
    private Path serverPatches;

    public PatchProvider(Project project) {
        super(project);
        this.projectCacheFolder = ForgeProvider.getForgeCache(project);
    }

    @Override
    public void provide(DependencyInfo dependency) throws Exception {
        this.init();
        this.installerJar = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve Forge installer")).toPath();
    }

    public Path extractClientPatches() {
        if (this.clientPatches == null) {
            this.clientPatches = this.projectCacheFolder.resolve("patches-client.lzma");
            this.extractPatches(this.clientPatches, "client.lzma");
        }
        return this.clientPatches;
    }

    public Path extractServerPatches() {
        if (this.serverPatches == null) {
            this.serverPatches = this.projectCacheFolder.resolve("patches-server.lzma");
            this.extractPatches(this.serverPatches, "server.lzma");
        }
        return this.serverPatches;
    }

    private void extractPatches(Path targetPath, String name) {
        if (Files.exists(targetPath, new LinkOption[0]) && !this.refreshDeps()) {
            return;
        }
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(this.installerJar, false);){
            Files.copy(fs.getPath("data", name), targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void init() {
        try {
            Files.createDirectories(this.projectCacheFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getTargetConfig() {
        return "forgeInstaller";
    }
}

