/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.accesstransformer;

import dev.architectury.at.AccessChange;
import dev.architectury.at.AccessTransform;
import dev.architectury.at.AccessTransformSet;
import dev.architectury.at.ModifierChange;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.classtweaker.api.ClassTweakerReader;
import net.fabricmc.classtweaker.api.visitor.AccessWidenerVisitor;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.task.RemapJarTask;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.VisibleForTesting;

public final class Aw2At {
    public static void setup(Project project, RemapJarTask remapJar) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        if (extension.getAccessWidenerPath().isPresent()) {
            String awName = null;
            Path awPath = ((RegularFile)extension.getAccessWidenerPath().get()).getAsFile().toPath();
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet main = (SourceSet)sourceSets.getByName("main");
            boolean found = false;
            for (File srcDir : main.getResources().getSrcDirs()) {
                Path srcDirPath = srcDir.toPath().toAbsolutePath();
                if (!awPath.startsWith(srcDirPath)) continue;
                awName = srcDirPath.relativize(awPath).toString().replace(File.separator, "/");
                found = true;
                break;
            }
            if (!found) {
                awName = awPath.getFileName().toString();
            }
            remapJar.getAtAccessWideners().add((Object)awName);
        }
        remapJar.getAtAccessWideners().addAll(extension.getForge().getExtraAccessWideners());
    }

    public static AccessTransformSet toAccessTransformSet(BufferedReader reader) throws IOException {
        final AccessTransformSet atSet = AccessTransformSet.create();
        ClassTweakerReader.create((ClassTweakerVisitor)new ClassTweakerVisitor(){

            public AccessWidenerVisitor visitAccessWidener(final String owner) {
                return new AccessWidenerVisitor(){

                    public void visitClass(AccessWidenerVisitor.AccessType access, boolean transitive) {
                        atSet.getOrCreateClass(owner).merge(Aw2At.toAt(access));
                    }

                    public void visitMethod(String name, String descriptor, AccessWidenerVisitor.AccessType access, boolean transitive) {
                        atSet.getOrCreateClass(owner).mergeMethod(MethodSignature.of((String)name, (String)descriptor), Aw2At.toAt(access));
                    }

                    public void visitField(String name, String descriptor, AccessWidenerVisitor.AccessType access, boolean transitive) {
                        atSet.getOrCreateClass(owner).mergeField(name, Aw2At.toAt(access));
                    }
                };
            }
        }).read(reader, "unused");
        return atSet;
    }

    @VisibleForTesting
    public static AccessTransform toAt(AccessWidenerVisitor.AccessType access) {
        return switch (access) {
            default -> throw new MatchException(null, null);
            case AccessWidenerVisitor.AccessType.ACCESSIBLE -> AccessTransform.of((AccessChange)AccessChange.PUBLIC);
            case AccessWidenerVisitor.AccessType.EXTENDABLE, AccessWidenerVisitor.AccessType.MUTABLE -> AccessTransform.of((AccessChange)AccessChange.PUBLIC, (ModifierChange)ModifierChange.REMOVE);
        };
    }
}

