/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom;

import dev.architectury.loom.forge.dependency.DependencyProviders;
import dev.architectury.loom.forge.dependency.ForgeProvider;
import dev.architectury.loom.forge.dependency.ForgeRunsProvider;
import dev.architectury.loom.forge.dependency.ForgeUniversalProvider;
import dev.architectury.loom.forge.dependency.ForgeUserdevProvider;
import dev.architectury.loom.forge.dependency.PatchProvider;
import dev.architectury.loom.forge.dependency.SrgProvider;
import dev.architectury.loom.mcpconfig.McpConfigProvider;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import net.fabricmc.loom.api.LoomGradleExtensionAPI;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerFile;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingsFactory;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.library.LibraryProcessorManager;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.IntermediaryMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MojangMappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.SrgMinecraftProvider;
import net.fabricmc.loom.extension.LoomFiles;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.extension.RemapperExtensionHolder;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.download.DownloadBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface LoomGradleExtension
extends LoomGradleExtensionAPI {
    public static LoomGradleExtension get(Project project) {
        return (LoomGradleExtension)project.getExtensions().getByName("loom");
    }

    public LoomFiles getFiles();

    public ConfigurableFileCollection getUnmappedModCollection();

    public void setInstallerData(InstallerData var1);

    public InstallerData getInstallerData();

    public MinecraftMetadataProvider getMetadataProvider();

    public void setMetadataProvider(MinecraftMetadataProvider var1);

    public MinecraftProvider getMinecraftProvider();

    public void setMinecraftProvider(MinecraftProvider var1);

    public MappingConfiguration getMappingConfiguration();

    public void setMappingConfiguration(MappingConfiguration var1);

    public NamedMinecraftProvider<?> getNamedMinecraftProvider();

    public IntermediaryMinecraftProvider<?> getIntermediaryMinecraftProvider();

    public void setNamedMinecraftProvider(NamedMinecraftProvider<?> var1);

    public void setIntermediaryMinecraftProvider(IntermediaryMinecraftProvider<?> var1);

    public SrgMinecraftProvider<?> getSrgMinecraftProvider();

    public void setSrgMinecraftProvider(SrgMinecraftProvider<?> var1);

    public MojangMappedMinecraftProvider<?> getMojangMappedMinecraftProvider();

    public void setMojangMappedMinecraftProvider(MojangMappedMinecraftProvider<?> var1);

    default public List<Path> getMinecraftJars(MappingsNamespace mappingsNamespace) {
        return switch (mappingsNamespace) {
            default -> throw new MatchException(null, null);
            case MappingsNamespace.NAMED -> this.getNamedMinecraftProvider().getMinecraftJarPaths();
            case MappingsNamespace.INTERMEDIARY -> this.getIntermediaryMinecraftProvider().getMinecraftJarPaths();
            case MappingsNamespace.OFFICIAL, MappingsNamespace.CLIENT_OFFICIAL, MappingsNamespace.SERVER_OFFICIAL -> this.getMinecraftProvider().getMinecraftJars();
            case MappingsNamespace.SRG -> {
                ModPlatform.assertPlatform(this, ModPlatform.FORGE, () -> "SRG jars are only available on Forge.");
                yield this.getSrgMinecraftProvider().getMinecraftJarPaths();
            }
            case MappingsNamespace.MOJANG -> {
                if (!this.isForgeLike() || !this.getForgeProvider().usesMojangAtRuntime()) {
                    throw new GradleException("Mojang-mapped jars are only available on NeoForge / Forge 50+.");
                }
                yield this.getMojangMappedMinecraftProvider().getMinecraftJarPaths();
            }
        };
    }

    public FileCollection getMinecraftJarsCollection(MappingsNamespace var1);

    @Override
    public MixinExtension getMixin();

    public List<AccessWidenerFile> getTransitiveAccessWideners();

    public void addTransitiveAccessWideners(List<AccessWidenerFile> var1);

    public DownloadBuilder download(String var1);

    public boolean refreshDeps();

    public void setRefreshDeps(boolean var1);

    public ListProperty<LibraryProcessorManager.LibraryProcessorFactory> getLibraryProcessors();

    public ListProperty<RemapperExtensionHolder> getRemapperExtensions();

    public Collection<LayeredMappingsFactory> getLayeredMappingFactories();

    public boolean isConfigurationCacheActive();

    public boolean isProjectIsolationActive();

    public boolean isCollectingDependencyVerificationMetadata();

    public boolean dontRemapOutputs();

    public boolean disableObfuscation();

    default public PatchProvider getPatchProvider() {
        return this.getDependencyProviders().getProvider(PatchProvider.class);
    }

    default public McpConfigProvider getMcpConfigProvider() {
        return this.getDependencyProviders().getProvider(McpConfigProvider.class);
    }

    default public boolean isDataGenEnabled() {
        return this.isForge() && !this.getForge().getDataGenMods().isEmpty();
    }

    default public boolean isForgeLikeAndOfficial() {
        return this.isForgeLike() && this.getMcpConfigProvider().isOfficial();
    }

    default public boolean isForgeLikeAndNotOfficial() {
        return this.isForgeLike() && !this.getMcpConfigProvider().isOfficial();
    }

    public DependencyProviders getDependencyProviders();

    public void setDependencyProviders(DependencyProviders var1);

    default public SrgProvider getSrgProvider() {
        return this.getDependencyProviders().getProvider(SrgProvider.class);
    }

    default public ForgeUniversalProvider getForgeUniversalProvider() {
        return this.getDependencyProviders().getProvider(ForgeUniversalProvider.class);
    }

    default public ForgeUserdevProvider getForgeUserdevProvider() {
        return this.getDependencyProviders().getProvider(ForgeUserdevProvider.class);
    }

    default public ForgeProvider getForgeProvider() {
        return this.getDependencyProviders().getProvider(ForgeProvider.class);
    }

    public ForgeRunsProvider getForgeRunsProvider();

    public void setForgeRunsProvider(ForgeRunsProvider var1);

    default public Path getPlatformMappingFile() {
        return this.getMappingConfiguration().getPlatformMappingFile(this);
    }

    public boolean manualRefreshDeps();
}

