/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public final class CollectionUtil {
    public static <E> Optional<E> find(Iterable<? extends E> collection, Predicate<? super E> filter) {
        for (E e : collection) {
            if (!filter.test(e)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static <E> int indexOf(List<? extends E> list, Predicate<? super E> filter) {
        for (int i = 0; i < list.size(); ++i) {
            if (!filter.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <A, B> List<B> map(Iterable<? extends A> collection, Function<? super A, ? extends B> transform) {
        return CollectionUtil.mapTo(collection, new ArrayList(), transform);
    }

    public static <A, B, C extends Collection<B>> C mapTo(Iterable<? extends A> collection, C target, Function<? super A, ? extends B> transform) {
        for (A a : collection) {
            target.add(transform.apply(a));
        }
        return target;
    }

    public static <A> List<A> filter(Collection<? extends A> collection, Predicate<? super A> filter) {
        ArrayList<A> result = new ArrayList<A>(collection);
        result.removeIf(filter.negate());
        return result;
    }

    public static <A> Optional<A> single(Iterable<? extends A> iterable) {
        Iterator<A> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return Optional.empty();
        }
        A single = iter.next();
        if (iter.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(single);
    }

    public static <A> Optional<A> first(Iterable<? extends A> iterable) {
        Iterator<A> iter = iterable.iterator();
        if (!iter.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(iter.next());
    }
}

