/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.loom.metadata.JsonBackedModMetadataFile;
import dev.architectury.loom.metadata.SingleIdModMetadataFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.ifaceinject.InterfaceInjectionProcessor;
import net.fabricmc.loom.util.ModPlatform;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.CheckSignatureAdapter;

public final class ArchitecturyCommonJson
implements JsonBackedModMetadataFile,
SingleIdModMetadataFile {
    public static final String FILE_NAME = "architectury.common.json";
    private static final String ACCESS_WIDENER_KEY = "accessWidener";
    private final JsonObject json;

    private ArchitecturyCommonJson(JsonObject json) {
        this.json = Objects.requireNonNull(json, "json");
    }

    public static ArchitecturyCommonJson of(byte[] utf8) {
        return ArchitecturyCommonJson.of(new String(utf8, StandardCharsets.UTF_8));
    }

    public static ArchitecturyCommonJson of(String text) {
        return ArchitecturyCommonJson.of((JsonObject)LoomGradlePlugin.GSON.fromJson(text, JsonObject.class));
    }

    public static ArchitecturyCommonJson of(Path path) throws IOException {
        return ArchitecturyCommonJson.of(Files.readString(path, StandardCharsets.UTF_8));
    }

    public static ArchitecturyCommonJson of(File file) throws IOException {
        return ArchitecturyCommonJson.of(file.toPath());
    }

    public static ArchitecturyCommonJson of(JsonObject json) {
        return new ArchitecturyCommonJson(json);
    }

    @Override
    public JsonObject getJson() {
        return this.json;
    }

    @Override
    @Nullable
    public String getId() {
        return null;
    }

    @Override
    public Set<String> getAccessWideners() {
        if (this.json.has(ACCESS_WIDENER_KEY)) {
            return Set.of(this.json.get(ACCESS_WIDENER_KEY).getAsString());
        }
        return Set.of();
    }

    @Override
    public Set<String> getAccessTransformers(ModPlatform platform) {
        return Set.of();
    }

    @Override
    public List<InterfaceInjectionProcessor.InjectedInterface> getInjectedInterfaces(@Nullable String modId) {
        if (modId == null) {
            throw new IllegalArgumentException("getInjectedInterfaces: mod ID has to be provided for architectury.common.json");
        }
        return ArchitecturyCommonJson.getInjectedInterfaces(this.json, modId);
    }

    static List<InterfaceInjectionProcessor.InjectedInterface> getInjectedInterfaces(JsonObject json, String modId) {
        Objects.requireNonNull(modId, "mod ID");
        if (json.has("injected_interfaces")) {
            JsonObject addedIfaces = json.getAsJsonObject("injected_interfaces");
            ArrayList<InterfaceInjectionProcessor.InjectedInterface> result = new ArrayList<InterfaceInjectionProcessor.InjectedInterface>();
            for (String className : addedIfaces.keySet()) {
                JsonArray ifacesInfo = addedIfaces.getAsJsonArray(className);
                for (JsonElement ifaceElement : ifacesInfo) {
                    String ifaceInfo;
                    String name = ifaceInfo = ifaceElement.getAsString();
                    String generics = null;
                    if (ifaceInfo.contains("<") && ifaceInfo.contains(">")) {
                        name = ifaceInfo.substring(0, ifaceInfo.indexOf("<"));
                        generics = ifaceInfo.substring(ifaceInfo.indexOf("<"));
                        SignatureReader reader = new SignatureReader("Ljava/lang/Object" + generics + ";");
                        CheckSignatureAdapter checker = new CheckSignatureAdapter(0, null);
                        reader.accept((SignatureVisitor)checker);
                    }
                    result.add(new InterfaceInjectionProcessor.InjectedInterface(modId, className, name, generics));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public String getFileName() {
        return FILE_NAME;
    }

    @Override
    public List<String> getMixinConfigs() {
        return List.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ArchitecturyCommonJson)) return false;
        ArchitecturyCommonJson acj = (ArchitecturyCommonJson)obj;
        if (!acj.json.equals((Object)this.json)) return false;
        return true;
    }

    public int hashCode() {
        return this.json.hashCode();
    }
}

