/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.mcpconfig.steplogic;

import dev.architectury.loom.forge.tool.ForgeToolExecutor;
import dev.architectury.loom.mcpconfig.McpConfigFunction;
import dev.architectury.loom.mcpconfig.steplogic.StepLogic;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import net.fabricmc.loom.util.Lazy;
import net.fabricmc.loom.util.service.Service;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.loom.util.service.ServiceType;
import org.gradle.api.Action;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;

public final class FunctionLogic
extends StepLogic<Options> {
    public static final ServiceType<Options, FunctionLogic> TYPE = new ServiceType<Options, FunctionLogic>(Options.class, FunctionLogic.class);

    public static Provider<Options> createOptions(StepLogic.SetupContext context, McpConfigFunction function) {
        return TYPE.create(context.project(), (Action<Options>)((Action)options -> {
            options.getFunction().set((Object)function);
            Provider jar = context.project().provider(((Supplier<File>)Lazy.of(() -> {
                try {
                    return function.download(context).toFile();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }))::get);
            options.getToolJar().set(context.project().getLayout().file(jar));
        }));
    }

    public FunctionLogic(Options options, ServiceFactory serviceFactory) {
        super(options, serviceFactory);
    }

    @Override
    public void execute(StepLogic.ExecutionContext context) throws IOException {
        String mainClass;
        context.setOutput("output.jar");
        McpConfigFunction function = (McpConfigFunction)((Options)this.getOptions()).getFunction().get();
        File jar = ((RegularFile)((Options)this.getOptions()).getToolJar().get()).getAsFile();
        try (JarFile jarFile = new JarFile(jar);){
            mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        }
        catch (IOException e) {
            throw new IOException("Could not determine main class for " + jar.getAbsolutePath(), e);
        }
        context.javaexec((Action<? super ForgeToolExecutor.Settings>)((Action)spec -> {
            spec.classpath(jar);
            spec.getMainClass().set((Object)mainClass);
            spec.args(context.resolve(function.args()));
            spec.jvmArgs(context.resolve(function.jvmArgs()));
        }));
    }

    @Override
    public String getDisplayName(String stepName) {
        return stepName + " with " + ((McpConfigFunction)((Options)this.getOptions()).getFunction().get()).version();
    }

    public static interface Options
    extends Service.Options {
        @Input
        public Property<McpConfigFunction> getFunction();

        @InputFile
        public RegularFileProperty getToolJar();
    }
}

