/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.ipc;

import java.io.IOException;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.fabricmc.loom.util.IOStringConsumer;

public final class IPCClient
implements IOStringConsumer,
AutoCloseable {
    private final Path path;
    private final SocketChannel socketChannel;

    public IPCClient(Path path) throws IOException {
        this.path = path;
        this.socketChannel = this.setupChannel();
    }

    private SocketChannel setupChannel() throws IOException {
        UnixDomainSocketAddress address = UnixDomainSocketAddress.of(this.path);
        return SocketChannel.open(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(String s) throws IOException {
        SocketChannel socketChannel = this.socketChannel;
        synchronized (socketChannel) {
            ByteBuffer buf = ByteBuffer.wrap((s + "\n").getBytes(StandardCharsets.UTF_8));
            while (buf.hasRemaining()) {
                this.socketChannel.write(buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        SocketChannel socketChannel = this.socketChannel;
        synchronized (socketChannel) {
            this.socketChannel.close();
        }
    }
}

