/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import dev.architectury.loom.forge.dependency.ForgeModClassesService;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.process.ProcessForkOptions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRunTask
extends JavaExec {
    private static final CharsetEncoder ASCII_ENCODER = StandardCharsets.US_ASCII.newEncoder();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRunTask.class);

    @Input
    protected abstract Property<String> getInternalRunDir();

    @Input
    protected abstract MapProperty<String, Object> getInternalEnvironmentVars();

    @Input
    protected abstract ListProperty<String> getInternalJvmArgs();

    @Input
    protected abstract Property<Boolean> getUseArgFile();

    @Input
    protected abstract Property<String> getProjectDir();

    @Input
    protected abstract Property<String> getArgFilePath();

    @InputFiles
    protected abstract ConfigurableFileCollection getInternalClasspath();

    @Nested
    @Optional
    @ApiStatus.Internal
    protected abstract Property<ForgeModClassesService.Options> getModClassesOptions();

    @Input
    @ApiStatus.Internal
    protected abstract Property<String> getRunConfigName();

    public AbstractRunTask(Function<Project, RunConfig> configProvider) {
        this.setGroup("loom");
        Provider config = this.getProject().provider(() -> (RunConfig)configProvider.apply(this.getProject()));
        this.getInternalClasspath().from(new Object[]{config.map(runConfig -> runConfig.sourceSet.getRuntimeClasspath().filter((Spec)new LibraryFilter(((RunConfig)config.get()).getExcludedLibraryPaths(this.getProject()), ((RunConfig)config.get()).configName)))});
        this.getArgumentProviders().add(() -> ((RunConfig)config.get()).programArgs);
        this.getMainClass().set(config.map(runConfig -> runConfig.mainClass));
        this.getJvmArguments().addAll(this.getProject().provider(this::getGameJvmArgs));
        this.getInternalRunDir().set(config.map(runConfig -> runConfig.runDir));
        this.getInternalEnvironmentVars().set(config.map(runConfig -> runConfig.environmentVariables));
        this.getInternalJvmArgs().set(config.map(runConfig -> runConfig.vmArgs));
        this.getUseArgFile().set(this.getProject().provider(this::canUseArgFile));
        this.getProjectDir().set((Object)this.getProject().getProjectDir().getAbsolutePath());
        File buildCache = LoomGradleExtension.get(this.getProject()).getFiles().getProjectBuildCache();
        File argFile = new File(buildCache, "argFiles/" + this.getName());
        this.getArgFilePath().set((Object)argFile.getAbsolutePath());
        this.getModClassesOptions().set(ForgeModClassesService.createOptions(this.getProject()));
        this.getRunConfigName().set(config.map(runConfig -> runConfig.name));
    }

    private boolean canUseArgFile() {
        if (!this.canPathBeASCIIEncoded()) {
            return false;
        }
        return this.getJavaVersion().isJava9Compatible();
    }

    private boolean canPathBeASCIIEncoded() {
        return ASCII_ENCODER.canEncode(this.getProject().getProjectDir().getAbsolutePath()) && ASCII_ENCODER.canEncode(this.getProject().getGradle().getGradleUserHomeDir().getAbsolutePath());
    }

    public void exec() {
        if (((Boolean)this.getUseArgFile().get()).booleanValue()) {
            LOGGER.debug("Using arg file for {}", (Object)this.getName());
            super.setClasspath((FileCollection)this.getObjectFactory().fileCollection());
        } else {
            LOGGER.debug("Using bare classpath for {}", (Object)this.getName());
            super.setClasspath((FileCollection)this.getInternalClasspath());
        }
        this.setWorkingDir(new File((String)this.getProjectDir().get(), (String)this.getInternalRunDir().get()));
        this.environment((Map)this.getInternalEnvironmentVars().get());
        this.configureForgeModClasses((ProcessForkOptions)this);
        super.exec();
    }

    protected void configureForgeModClasses(ProcessForkOptions forkOptions) {
        try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
            ForgeModClassesService service = (ForgeModClassesService)serviceFactory.getOrNull(this.getModClassesOptions());
            if (service != null && "{source_roots}".equals(forkOptions.getEnvironment().get("MOD_CLASSES"))) {
                forkOptions.environment("MOD_CLASSES", (Object)service.getModClasses((String)this.getRunConfigName().get()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setWorkingDir(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        super.setWorkingDir(dir);
    }

    private List<String> getGameJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (((Boolean)this.getUseArgFile().get()).booleanValue()) {
            String content = "-classpath\n" + this.getInternalClasspath().getFiles().stream().map(File::getAbsolutePath).map(AbstractRunTask::quoteArg).collect(Collectors.joining(File.pathSeparator));
            try {
                Path argsFile = Paths.get((String)this.getArgFilePath().get(), new String[0]);
                Files.createDirectories(argsFile.getParent(), new FileAttribute[0]);
                Files.writeString(argsFile, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                args.add("@" + String.valueOf(argsFile.toAbsolutePath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create classpath file", e);
            }
        }
        args.addAll((Collection)this.getInternalJvmArgs().get());
        return args;
    }

    private static String quoteArg(String arg) {
        String specials = " #'\"\n\r\t\f";
        if (!AbstractRunTask.containsAnyChar(arg, " #'\"\n\r\t\f")) {
            return arg;
        }
        StringBuilder sb = new StringBuilder(arg.length() * 2);
        block8: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '\'': {
                    sb.append('\"').append(c).append('\"');
                    continue block8;
                }
                case '\"': {
                    sb.append("\"\\\"\"");
                    continue block8;
                }
                case '\n': {
                    sb.append("\"\\n\"");
                    continue block8;
                }
                case '\r': {
                    sb.append("\"\\r\"");
                    continue block8;
                }
                case '\t': {
                    sb.append("\"\\t\"");
                    continue block8;
                }
                case '\f': {
                    sb.append("\"\\f\"");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        return chars.length() > value.length() ? AbstractRunTask.containsAnyChar(value, chars, 0, value.length()) : AbstractRunTask.containsAnyChar(chars, value, 0, chars.length());
    }

    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public JavaExec setClasspath(@NotNull FileCollection classpath) {
        this.getInternalClasspath().setFrom((Iterable)classpath);
        return this;
    }

    @NotNull
    public JavaExec classpath(Object ... paths) {
        this.getInternalClasspath().from(paths);
        return this;
    }

    @NotNull
    public FileCollection getClasspath() {
        return this.getInternalClasspath();
    }

    public record LibraryFilter(List<String> excludedLibraryPaths, String configName) implements Spec<File>
    {
        public boolean isSatisfiedBy(File element) {
            if (this.excludedLibraryPaths.contains(element.getAbsolutePath())) {
                LOGGER.debug("Excluding library {} from {} run config", (Object)element.getName(), (Object)this.configName);
                return false;
            }
            return true;
        }
    }
}

