/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.architectury.loom.metadata.ModMetadataFile;
import dev.architectury.loom.metadata.ModMetadataFiles;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonSource;
import net.fabricmc.loom.util.fmj.FabricModJsonUtils;
import net.fabricmc.loom.util.fmj.FabricModJsonV0;
import net.fabricmc.loom.util.fmj.FabricModJsonV1;
import net.fabricmc.loom.util.fmj.FabricModJsonV2;
import net.fabricmc.loom.util.fmj.ModMetadataFabricModJson;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricModJsonFactory {
    public static final String FABRIC_MOD_JSON = "fabric.mod.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricModJsonFactory.class);

    private FabricModJsonFactory() {
    }

    @VisibleForTesting
    public static FabricModJson create(JsonObject jsonObject, FabricModJsonSource source) {
        int schemaVersion = 0;
        if (jsonObject.has("schemaVersion")) {
            schemaVersion = FabricModJsonUtils.readInt(jsonObject, "schemaVersion");
        }
        return switch (schemaVersion) {
            case 0 -> new FabricModJsonV0(jsonObject, source);
            case 1 -> new FabricModJsonV1(jsonObject, source);
            case 2 -> new FabricModJsonV2(jsonObject, source);
            default -> throw new UnsupportedOperationException(String.format("This version of fabric-loom doesn't support the newer fabric.mod.json schema version of (%s) Please update fabric-loom to be able to read this.", schemaVersion));
        };
    }

    public static FabricModJson createFromZip(Path zipPath) {
        try {
            return FabricModJsonFactory.create(ZipUtils.unpackGson(zipPath, FABRIC_MOD_JSON, JsonObject.class), new FabricModJsonSource.ZipSource(zipPath));
        }
        catch (IOException e) {
            try {
                @Nullable ModMetadataFile modMetadata = ModMetadataFiles.fromJar(zipPath);
                if (modMetadata != null) {
                    return new ModMetadataFabricModJson(modMetadata, (FabricModJsonSource)new FabricModJsonSource.ZipSource(zipPath));
                }
            }
            catch (IOException e2) {
                UncheckedIOException unchecked = new UncheckedIOException("Failed to read mod metadata file in zip: " + String.valueOf(zipPath), e2);
                unchecked.addSuppressed(e);
                throw unchecked;
            }
            throw new UncheckedIOException("Failed to read fabric.mod.json file in zip: " + String.valueOf(zipPath), e);
        }
        catch (JsonSyntaxException e) {
            throw new JsonSyntaxException("Failed to parse fabric.mod.json in zip: " + String.valueOf(zipPath), (Throwable)e);
        }
    }

    @Nullable
    public static FabricModJson createFromZipNullable(Path zipPath) {
        JsonObject jsonObject;
        try {
            jsonObject = ZipUtils.unpackGsonNullable(zipPath, FABRIC_MOD_JSON, JsonObject.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read zip: " + String.valueOf(zipPath), e);
        }
        catch (JsonSyntaxException e) {
            throw new JsonSyntaxException("Failed to parse fabric.mod.json in zip: " + String.valueOf(zipPath), (Throwable)e);
        }
        if (jsonObject == null) {
            try {
                @Nullable ModMetadataFile modMetadata = ModMetadataFiles.fromJar(zipPath);
                if (modMetadata != null) {
                    return new ModMetadataFabricModJson(modMetadata, (FabricModJsonSource)new FabricModJsonSource.ZipSource(zipPath));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read mod metadata file in zip: " + String.valueOf(zipPath), e);
            }
            return null;
        }
        return FabricModJsonFactory.create(jsonObject, new FabricModJsonSource.ZipSource(zipPath));
    }

    public static Optional<FabricModJson> createFromZipOptional(Path zipPath) {
        return Optional.ofNullable(FabricModJsonFactory.createFromZipNullable(zipPath));
    }

    public static FabricModJson createFromFile(File file) {
        JsonObject modJson = FabricModJsonFactory.readFmjJsonObject(file);
        return FabricModJsonFactory.create(modJson, new FabricModJsonSource.DirectorySource(file.toPath().getParent()));
    }

    @Nullable
    public static FabricModJson createFromSourceSetsNullable(Project project, SourceSet ... sourceSets) {
        File file = SourceSetHelper.findFirstFileInResource(FABRIC_MOD_JSON, project, sourceSets);
        if (file == null) {
            try {
                @Nullable ModMetadataFile modMetadata = ModMetadataFiles.fromSourceSets(project, sourceSets);
                if (modMetadata != null) {
                    return new ModMetadataFabricModJson(modMetadata, (FabricModJsonSource)new FabricModJsonSource.SourceSetSource(project, sourceSets));
                }
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try {
            JsonObject modJson = FabricModJsonFactory.readFmjJsonObject(file);
            return FabricModJsonFactory.create(modJson, new FabricModJsonSource.SourceSetSource(project, sourceSets));
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Failed to parse fabric.mod.json: {}", (Object)file.getAbsolutePath());
            return null;
        }
    }

    private static JsonObject readFmjJsonObject(File file) {
        JsonObject jsonObject;
        block9: {
            BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
            try {
                JsonObject modJson = (JsonObject)LoomGradlePlugin.GSON.fromJson((Reader)reader, JsonObject.class);
                if (modJson == null) {
                    LOGGER.warn("Failed to parse empty fabric.mod.json: {}", (Object)file.getAbsolutePath());
                }
                jsonObject = modJson;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read " + file.getAbsolutePath(), e);
                }
            }
            ((Reader)reader).close();
        }
        return jsonObject;
    }

    public static boolean isModJar(File file, ModPlatform platform) {
        return FabricModJsonFactory.isModJar(file.toPath(), platform);
    }

    public static boolean isModJar(Path input, ModPlatform platform) {
        if (platform.isForgeLike()) {
            return ZipUtils.contains(input, "META-INF/mods.toml") || platform == ModPlatform.NEOFORGE && ZipUtils.contains(input, "META-INF/neoforge.mods.toml");
        }
        if (platform == ModPlatform.QUILT) {
            return ZipUtils.contains(input, "quilt.mod.json") || FabricModJsonFactory.isModJar(input, ModPlatform.FABRIC);
        }
        return ZipUtils.contains(input, FABRIC_MOD_JSON);
    }

    public static boolean isNestableModJar(File file, ModPlatform platform) {
        return FabricModJsonFactory.isNestableModJar(file.toPath(), platform);
    }

    public static boolean isNestableModJar(Path input, ModPlatform platform) {
        if (platform.isForgeLike()) {
            return true;
        }
        return FabricModJsonFactory.isModJar(input, platform);
    }

    public static boolean containsMod(FileSystemUtil.Delegate fs, ModPlatform platform) {
        if (Files.exists(fs.getPath("architectury.common.marker", new String[0]), new LinkOption[0])) {
            return true;
        }
        if (platform.isForgeLike()) {
            return Files.exists(fs.getPath("META-INF/mods.toml", new String[0]), new LinkOption[0]) || platform == ModPlatform.NEOFORGE && Files.exists(fs.getPath("META-INF/neoforge.mods.toml", new String[0]), new LinkOption[0]);
        }
        if (platform == ModPlatform.QUILT) {
            return Files.exists(fs.getPath("quilt.mod.json", new String[0]), new LinkOption[0]) || FabricModJsonFactory.containsMod(fs, ModPlatform.FABRIC);
        }
        return Files.exists(fs.getPath(FABRIC_MOD_JSON, new String[0]), new LinkOption[0]);
    }
}

