/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.launch;

import dev.architectury.loom.forge.config.ForgeRunTemplate;
import dev.architectury.loom.forge.dependency.ForgeRunsProvider;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.build.IntermediaryNamespaces;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.task.service.ClasspathGroupService;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.ApiStatus;

public abstract class GenerateDLIConfigTask
extends AbstractLoomTask {
    @Input
    protected abstract Property<String> getVersionInfoJson();

    @Input
    protected abstract Property<String> getMinecraftVersion();

    @Input
    protected abstract Property<Boolean> getSplitSourceSets();

    @Input
    protected abstract Property<Boolean> getPlainConsole();

    @Input
    protected abstract Property<Boolean> getANSISupportedIDE();

    @Input
    protected abstract Property<String> getLog4jConfigPaths();

    @Input
    @Optional
    protected abstract Property<String> getClientGameJarPath();

    @Input
    @Optional
    protected abstract Property<String> getCommonGameJarPath();

    @Input
    protected abstract Property<String> getAssetsDirectoryPath();

    @Input
    protected abstract Property<String> getNativesDirectoryPath();

    @InputFile
    public abstract RegularFileProperty getRemapClasspathFile();

    @OutputFile
    protected abstract RegularFileProperty getDevLauncherConfig();

    @Nested
    protected abstract Property<ClasspathGroupService.Options> getClasspathGroupOptions();

    @Input
    @Optional
    @ApiStatus.Internal
    protected abstract Property<ForgeInputs> getForgeInputs();

    @InputFile
    @ApiStatus.Internal
    protected abstract RegularFileProperty getPlatformMappingFile();

    @InputFiles
    @ApiStatus.Internal
    protected abstract ConfigurableFileCollection getMappingJars();

    @Input
    @ApiStatus.Internal
    protected abstract SetProperty<ForgeRunTemplate.Resolved> getRunTemplates();

    public GenerateDLIConfigTask() {
        this.getVersionInfoJson().set((Object)LoomGradlePlugin.GSON.toJson((Object)this.getExtension().getMinecraftProvider().getVersionInfo()));
        this.getMinecraftVersion().set((Object)this.getExtension().getMinecraftProvider().minecraftVersion());
        this.getSplitSourceSets().set((Object)this.getExtension().areEnvironmentSourceSetsSplit());
        this.getANSISupportedIDE().set((Object)GenerateDLIConfigTask.ansiSupportedIde(this.getProject()));
        this.getPlainConsole().set((Object)(this.getProject().getGradle().getStartParameter().getConsoleOutput() == ConsoleOutput.Plain ? 1 : 0));
        this.getClasspathGroupOptions().set(ClasspathGroupService.create(this.getProject()));
        this.getLog4jConfigPaths().set((Object)GenerateDLIConfigTask.getAllLog4JConfigFiles(this.getProject()));
        if (((Boolean)this.getSplitSourceSets().get()).booleanValue()) {
            this.getClientGameJarPath().set((Object)this.getGameJarPath("client"));
            this.getCommonGameJarPath().set((Object)this.getGameJarPath("common"));
        }
        this.getAssetsDirectoryPath().set((Object)new File(this.getExtension().getFiles().getUserCache(), "assets").getAbsolutePath());
        this.getNativesDirectoryPath().set((Object)this.getExtension().getFiles().getNativesDirectory(this.getProject()).getAbsolutePath());
        this.getDevLauncherConfig().set(this.getExtension().getFiles().getDevLauncherConfig());
        this.getPlatformMappingFile().set(this.getProject().getLayout().file(this.getProject().provider(() -> this.getExtension().getPlatformMappingFile().toFile())));
        this.getPlatformMappingFile().finalizeValue();
        this.getMappingJars().from(new Object[]{this.getProject().getConfigurations().getByName("mappingsFinal")});
        if (this.getExtension().isForgeLike()) {
            this.getRunTemplates().addAll(this.getProject().provider(() -> {
                ForgeRunsProvider forgeRunsProvider = this.getExtension().getForgeRunsProvider();
                return forgeRunsProvider.getTemplates().stream().map(template -> template.resolve(forgeRunsProvider)).toList();
            }));
            if (this.getExtension().isForge()) {
                this.getForgeInputs().set(this.getProject().provider(() -> new ForgeInputs(this.getProject(), this.getExtension())));
            }
        } else {
            this.getRunTemplates().empty();
        }
    }

    @TaskAction
    public void run() throws IOException {
        ModPlatform platform;
        MinecraftVersionMeta versionInfo = (MinecraftVersionMeta)LoomGradlePlugin.GSON.fromJson((String)this.getVersionInfoJson().get(), MinecraftVersionMeta.class);
        File assetsDirectory = new File((String)this.getAssetsDirectoryPath().get());
        if (versionInfo.assets().equals("legacy")) {
            assetsDirectory = new File(assetsDirectory, "/legacy/" + versionInfo.id());
        }
        boolean quilt = (platform = (ModPlatform)((Object)this.getModPlatform().get())) == ModPlatform.QUILT;
        LaunchConfig launchConfig = new LaunchConfig().property(!quilt ? "fabric.development" : "loader.development", "true").property(!quilt ? "fabric.remapClasspathFile" : "loader.remapClasspathFile", ((RegularFile)this.getRemapClasspathFile().get()).getAsFile().getAbsolutePath()).property("log4j.configurationFile", (String)this.getLog4jConfigPaths().get()).property("log4j2.formatMsgNoLookups", "true");
        if (versionInfo.hasNativesToExtract()) {
            String nativesPath = (String)this.getNativesDirectoryPath().get();
            launchConfig.property("client", "java.library.path", nativesPath).property("client", "org.lwjgl.librarypath", nativesPath);
        }
        if (!platform.isForgeLike()) {
            launchConfig.argument("client", "--assetIndex").argument("client", versionInfo.assetIndex().fabricId((String)this.getMinecraftVersion().get())).argument("client", "--assetsDir").argument("client", assetsDirectory.getAbsolutePath());
            if (((Boolean)this.getSplitSourceSets().get()).booleanValue()) {
                launchConfig.property("client", !quilt ? "fabric.gameJarPath.client" : "loader.gameJarPath.client", (String)this.getClientGameJarPath().get());
                launchConfig.property(!quilt ? "fabric.gameJarPath" : "loader.gameJarPath", (String)this.getCommonGameJarPath().get());
            }
            try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
                ClasspathGroupService classpathGroupService = (ClasspathGroupService)serviceFactory.get(this.getClasspathGroupOptions());
                if (classpathGroupService.hasGroups()) {
                    launchConfig.property(!quilt ? "fabric.classPathGroups" : "loader.classPathGroups", classpathGroupService.getClasspathGroupsPropertyValue());
                }
            }
        }
        if (quilt) {
            launchConfig.argument("client", "--version").argument("client", "Architectury Loom").property("loader.enable_quilt_mod_json5_in_dev_env", "true");
        }
        if (platform.isForgeLike()) {
            String unprotectMappings = this.getMappingJars().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
            String intermediateNs = IntermediaryNamespaces.intermediaryNamespace(platform).toString();
            String mappingsPath = ((RegularFile)this.getPlatformMappingFile().get()).getAsFile().getAbsolutePath();
            launchConfig.property("unprotect.mappings", unprotectMappings).property("architectury.naming.sourceNamespace", intermediateNs).property("architectury.naming.mappingsPath", mappingsPath);
            if (platform == ModPlatform.FORGE) {
                ForgeInputs forgeInputs = Objects.requireNonNull((ForgeInputs)this.getForgeInputs().getOrNull());
                List<String> dataGenMods = forgeInputs.dataGenMods();
                if (!dataGenMods.isEmpty()) {
                    launchConfig.argument("data", "--all").argument("data", "--mod").argument("data", String.join((CharSequence)",", dataGenMods)).argument("data", "--output").argument("data", forgeInputs.legacyDataGenDir());
                }
                launchConfig.property("mixin.env.remapRefMap", "true");
                if (forgeInputs.useCustomMixin()) {
                    launchConfig.property("architectury.mixinRemapper.sourceNamespace", intermediateNs).property("architectury.mixinRemapper.mappingsPath", mappingsPath);
                } else {
                    launchConfig.property("net.minecraftforge.gradle.GradleStart.srg.srg-mcp", forgeInputs.srgToNamedSrg());
                }
                Set<String> mixinConfigs = forgeInputs.mixinConfigs();
                if (!mixinConfigs.isEmpty()) {
                    for (String string : mixinConfigs) {
                        launchConfig.argument("-mixin.config");
                        launchConfig.argument(string);
                    }
                }
            }
            for (ForgeRunTemplate.Resolved template : (Set)this.getRunTemplates().get()) {
                String env = template.name().toLowerCase(Locale.ROOT);
                for (String string : template.args()) {
                    launchConfig.argument(env, string);
                }
                for (Map.Entry entry : template.props().entrySet()) {
                    launchConfig.property(env, (String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        if (((Boolean)this.getANSISupportedIDE().get()).booleanValue() && !((Boolean)this.getPlainConsole().get()).booleanValue()) {
            launchConfig.property("fabric.log.disableAnsi", "false");
        }
        Files.writeString(((File)this.getDevLauncherConfig().getAsFile().get()).toPath(), (CharSequence)launchConfig.asString(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String getAllLog4JConfigFiles(Project project) {
        return LoomGradleExtension.get(project).getLog4jConfigs().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(","));
    }

    private String getGameJarPath(String env) {
        MappedMinecraftProvider.Split split = (MappedMinecraftProvider.Split)((Object)this.getExtension().getNamedMinecraftProvider());
        return switch (env) {
            case "client" -> split.getClientOnlyJar().getPath().toAbsolutePath().toString();
            case "common" -> split.getCommonJar().getPath().toAbsolutePath().toString();
            default -> throw new UnsupportedOperationException();
        };
    }

    private static boolean ansiSupportedIde(Project project) {
        File rootDir = project.getRootDir();
        return new File(rootDir, ".vscode").exists() || new File(rootDir, ".idea").exists() || new File(rootDir, ".project").exists() || Arrays.stream(rootDir.listFiles()).anyMatch(file -> file.getName().endsWith(".iws"));
    }

    public static class LaunchConfig {
        private final Map<String, List<String>> values = new HashMap<String, List<String>>();

        public LaunchConfig property(String key, String value) {
            return this.property("common", key, value);
        }

        public LaunchConfig property(String side, String key, String value) {
            this.values.computeIfAbsent(side + "Properties", s -> new ArrayList()).add(String.format("%s=%s", key, value));
            return this;
        }

        public LaunchConfig argument(String value) {
            return this.argument("common", value);
        }

        public LaunchConfig argument(String side, String value) {
            this.values.computeIfAbsent(side + "Args", s -> new ArrayList()).add(value);
            return this;
        }

        public String asString() {
            StringJoiner stringJoiner = new StringJoiner("\n");
            for (Map.Entry<String, List<String>> entry : this.values.entrySet()) {
                stringJoiner.add(entry.getKey());
                for (String s : entry.getValue()) {
                    stringJoiner.add("\t" + s);
                }
            }
            return stringJoiner.toString();
        }
    }

    @ApiStatus.Internal
    public record ForgeInputs(List<String> dataGenMods, String legacyDataGenDir, Set<String> mixinConfigs, boolean useCustomMixin, String srgToNamedSrg) implements Serializable
    {
        public ForgeInputs(Project project, LoomGradleExtension extension) {
            this(extension.getForge().getDataGenMods(), project.file((Object)"src/generated/resources").getAbsolutePath(), (Set)extension.getForge().getMixinConfigs().get(), (Boolean)extension.getForge().getUseCustomMixin().get(), extension.getMappingConfiguration().srgToNamedSrg.toAbsolutePath().toString());
        }
    }
}

