/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import net.fabricmc.classtweaker.api.ClassTweakerReader;
import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.classtweaker.validator.ClassTweakerValidatingVisitor;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.util.TinyRemapperLoggerAdapter;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrLogger;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

public abstract class ValidateAccessWidenerTask
extends DefaultTask {
    @SkipWhenEmpty
    @InputFile
    public abstract RegularFileProperty getAccessWidener();

    @InputFiles
    public abstract ConfigurableFileCollection getTargetJars();

    @Inject
    public ValidateAccessWidenerTask() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        this.getAccessWidener().convention((Provider)extension.getAccessWidenerPath()).finalizeValueOnRead();
        this.getTargetJars().from(new Object[]{extension.getMinecraftJarsCollection(MappingsNamespace.NAMED)}).finalizeValueOnRead();
        this.getOutputs().upToDateWhen(task -> true);
    }

    @TaskAction
    public void run() {
        TinyRemapper tinyRemapper = TinyRemapper.newRemapper((TrLogger)TinyRemapperLoggerAdapter.INSTANCE).build();
        for (File file : this.getTargetJars().getFiles()) {
            tinyRemapper.readClassPath(new Path[]{file.toPath()});
        }
        AtomicBoolean hasProblem = new AtomicBoolean(false);
        ClassTweakerValidatingVisitor validator = new ClassTweakerValidatingVisitor(tinyRemapper.getEnvironment(), (lineNumber, message) -> {
            hasProblem.set(true);
            this.getLogger().error("{} on line {}", (Object)message, (Object)lineNumber);
        });
        ClassTweakerReader accessWidenerReader = ClassTweakerReader.create((ClassTweakerVisitor)validator);
        try (BufferedReader reader = Files.newBufferedReader(((RegularFile)this.getAccessWidener().get()).getAsFile().toPath(), StandardCharsets.UTF_8);){
            accessWidenerReader.read(reader, "named");
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read access widener", e);
        }
        finally {
            tinyRemapper.finish();
        }
        if (hasProblem.get()) {
            this.getLogger().error("access-widener validation failed for {}", (Object)((RegularFile)this.getAccessWidener().get()).getAsFile().getName());
            throw new RuntimeException("access-widener validation failed for %s".formatted(((RegularFile)this.getAccessWidener().get()).getAsFile().getName()));
        }
    }
}

