/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.classpathgroups;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.loom.api.ModSettings;
import net.fabricmc.loom.configuration.classpathgroups.ExternalClasspathGroup;
import org.gradle.api.file.FileSystemLocation;
import org.jetbrains.annotations.Nullable;

public record ClasspathGroup(String name, @Nullable String resourceDir, List<String> paths, List<ExternalClasspathGroup> externalGroups) implements Serializable
{
    public ClasspathGroup(String name, @Nullable String resourceDir, List<String> paths, List<ExternalClasspathGroup> externalGroups) {
        this.name = name;
        this.resourceDir = resourceDir;
        this.paths = new ArrayList<String>(paths);
        this.externalGroups = new ArrayList<ExternalClasspathGroup>(externalGroups);
    }

    public static List<ClasspathGroup> fromModSettings(Set<ModSettings> modSettings) {
        return modSettings.stream().map(s -> new ClasspathGroup(s.getName(), ClasspathGroup.getAbsolutePath((FileSystemLocation)s.getMainResourceDirectory().getOrNull()), ClasspathGroup.getPaths(s), (List)s.getExternalGroups().get())).toList();
    }

    private static List<String> getPaths(ModSettings modSettings) {
        return modSettings.getModFiles().getFiles().stream().map(File::getAbsolutePath).toList();
    }

    @Nullable
    private static String getAbsolutePath(@Nullable FileSystemLocation location) {
        if (location == null) {
            return null;
        }
        return location.getAsFile().getAbsolutePath();
    }
}

