/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.util.collection;

import dev.architectury.loom.util.collection.MultimapImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedSet;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.loom.util.Pair;

public interface Multimap<K, V> {
    public static <K, V> Specialized<K, V, SequencedSet<V>> setMultimap() {
        return new MultimapImpl(new HashMap(), LinkedHashSet::new, Collections.emptySortedSet());
    }

    public static <K, V> Specialized<K, V, List<V>> listMultimap() {
        return new MultimapImpl(new HashMap(), ArrayList::new, List.of());
    }

    public Collection<V> get(K var1);

    public void put(K var1, V var2);

    public void putAll(K var1, Collection<? extends V> var2);

    public Set<K> keySet();

    public Map<K, ? extends Collection<V>> asMap();

    public Set<? extends Map.Entry<K, ? extends Collection<V>>> entrySet();

    default public Stream<Pair<K, V>> streamEntries() {
        return this.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(value -> new Pair(entry.getKey(), value)));
    }

    public static interface Specialized<K, V, C extends Collection<V>>
    extends Multimap<K, V> {
        public C get(K var1);

        @Override
        public Map<K, ? extends C> asMap();

        @Override
        public Set<Map.Entry<K, C>> entrySet();
    }
}

