/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.util;

import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public final class Stopwatch {
    @Nullable
    private Instant start;

    private Stopwatch() {
    }

    public boolean isRunning() {
        return this.start != null;
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("Stopwatch already started");
        }
        this.start = Instant.now();
    }

    public Stopped stop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Stopwatch not started");
        }
        Instant end = Instant.now();
        Duration duration = Duration.between(this.start, end);
        return new Stopped(duration);
    }

    public static Stopwatch createStarted() {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        return stopwatch;
    }

    public static Stopwatch createUnstarted() {
        return new Stopwatch();
    }

    public String toString() {
        return this.isRunning() ? "Stopwatch[running]" : "Stopwatch[unstarted]";
    }

    public record Stopped(Duration duration) {
        @Override
        public String toString() {
            if (this.duration.toDays() > 0L) {
                return this.duration.toDays() + "d";
            }
            if (this.duration.toHours() > 0L) {
                return this.duration.toHours() + "h " + this.duration.toMinutesPart() + "min";
            }
            if (this.duration.toMinutes() > 0L) {
                return this.duration.toMinutes() + "min " + this.duration.toSecondsPart() + "s";
            }
            if (this.duration.toSeconds() > 0L) {
                return this.duration.toSeconds() + "s";
            }
            if (this.duration.toMillis() > 0L) {
                return this.duration.toMillis() + "ms";
            }
            return this.duration.toNanos() + "ns";
        }
    }
}

