/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.neoforge;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarSplitter;
import net.fabricmc.mappingio.tree.MappingTreeView;

public final class SidedJarIndexGenerator {
    private final Path clientJar;
    private final Path serverJar;
    private final MappingTreeView mappings;

    public SidedJarIndexGenerator(Path clientJar, Path serverJar, MappingTreeView mappings) {
        this.clientJar = clientJar;
        this.serverJar = serverJar;
        this.mappings = mappings;
    }

    public void split(FileDistConsumer consumer) throws IOException {
        Set<String> clientEntries = MinecraftJarSplitter.getJarEntries(this.clientJar);
        Set<String> serverEntries = MinecraftJarSplitter.getJarEntries(this.serverJar);
        this.consumeAll(consumer, "client", clientEntries, serverEntries);
        this.consumeAll(consumer, "server", serverEntries, clientEntries);
    }

    private void consumeAll(FileDistConsumer consumer, String dist, Set<String> distEntries, Set<String> otherEntries) {
        for (String entry : distEntries) {
            if (otherEntries.contains(entry)) continue;
            consumer.acceptFile(this.processFilePath(entry), dist);
        }
    }

    private String processFilePath(String filePath) {
        String remappedName;
        String className;
        MappingTreeView.ClassMappingView mapping;
        if (filePath.endsWith(".class") && (mapping = this.mappings.getClass(className = filePath.substring(0, filePath.length() - ".class".length()))) != null && (remappedName = mapping.getName(MappingsNamespace.NAMED.toString())) != null) {
            return remappedName + ".class";
        }
        return filePath;
    }

    @FunctionalInterface
    public static interface FileDistConsumer {
        public void acceptFile(String var1, String var2);
    }
}

