/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.metadata;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.api.SyntaxError;
import dev.architectury.loom.metadata.ArchitecturyCommonJson;
import dev.architectury.loom.metadata.ErroringModMetadataFile;
import dev.architectury.loom.metadata.ModMetadataFile;
import dev.architectury.loom.metadata.ModsToml;
import dev.architectury.loom.metadata.QuiltModJson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.Nullable;

public final class ModMetadataFiles {
    private static final Logger LOGGER = Logging.getLogger(ModMetadataFiles.class);
    private static final Map<String, Function<byte[], ModMetadataFile>> SINGLE_FILE_METADATA_TYPES = Map.of("quilt.mod.json", QuiltModJson::of, "quilt.mod.json5", ModMetadataFiles.convertJson5ToJson(QuiltModJson::of), "architectury.common.json", ArchitecturyCommonJson::of, "META-INF/mods.toml", ModMetadataFiles.onError(ModsToml::of, "Could not load mods.toml", () -> new ErroringModMetadataFile("mods.toml")), "META-INF/neoforge.mods.toml", ModMetadataFiles.onError(ModsToml::of, "Could not load neoforge.mods.toml", () -> new ErroringModMetadataFile("neoforge.mods.toml")));

    private static <A, B> Function<A, B> onError(Function<A, B> fn, String message, Supplier<B> onError) {
        return a -> {
            try {
                return fn.apply(a);
            }
            catch (Exception e) {
                LOGGER.info(message, (Throwable)e);
                return onError.get();
            }
        };
    }

    private static <R> Function<byte[], R> convertJson5ToJson(Function<byte[], R> next) {
        return bytes -> {
            String json;
            String text = new String((byte[])bytes, StandardCharsets.UTF_8);
            Jankson jankson = Jankson.builder().build();
            try {
                json = ((JsonElement)jankson.fromJson(text, JsonElement.class)).toJson(JsonGrammar.STRICT);
            }
            catch (SyntaxError e) {
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Could not read JSON5 file", e);
            }
            return next.apply(json.getBytes(StandardCharsets.UTF_8));
        };
    }

    @Nullable
    public static ModMetadataFile fromJar(Path jar) throws IOException {
        for (String filePath : SINGLE_FILE_METADATA_TYPES.keySet()) {
            byte @Nullable [] bytes = ZipUtils.unpackNullable(jar, filePath);
            if (bytes == null) continue;
            return SINGLE_FILE_METADATA_TYPES.get(filePath).apply(bytes);
        }
        return null;
    }

    @Nullable
    public static ModMetadataFile fromDirectory(Path directory) throws IOException {
        for (String filePath : SINGLE_FILE_METADATA_TYPES.keySet()) {
            Path metadataPath = directory.resolve(filePath);
            if (!Files.exists(metadataPath, new LinkOption[0])) continue;
            return SINGLE_FILE_METADATA_TYPES.get(filePath).apply(Files.readAllBytes(metadataPath));
        }
        return null;
    }

    @Nullable
    public static ModMetadataFile fromSourceSets(Project project, SourceSet ... sourceSets) throws IOException {
        for (String filePath : SINGLE_FILE_METADATA_TYPES.keySet()) {
            @Nullable File file = SourceSetHelper.findFirstFileInResource(filePath, project, sourceSets);
            if (file == null) continue;
            return SINGLE_FILE_METADATA_TYPES.get(filePath).apply(Files.readAllBytes(file.toPath()));
        }
        return null;
    }
}

