/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.dependency;

import dev.architectury.loom.forge.dependency.DependencyProvider;
import dev.architectury.loom.forge.dependency.ForgeProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.util.FileSystemUtil;
import org.gradle.api.Project;

public class PatchProvider
extends DependencyProvider {
    public Path clientPatches;
    public Path serverPatches;

    public PatchProvider(Project project) {
        super(project);
    }

    @Override
    public void provide(DependencyInfo dependency) throws Exception {
        this.init();
        if (Files.notExists(this.clientPatches, new LinkOption[0]) || Files.notExists(this.serverPatches, new LinkOption[0]) || this.refreshDeps()) {
            this.getProject().getLogger().info(":extracting forge patches");
            Path installerJar = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve Forge installer")).toPath();
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(installerJar, false);){
                Files.copy(fs.getPath("data", "client.lzma"), this.clientPatches, StandardCopyOption.REPLACE_EXISTING);
                Files.copy(fs.getPath("data", "server.lzma"), this.serverPatches, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void init() {
        Path projectCacheFolder = ForgeProvider.getForgeCache(this.getProject());
        this.clientPatches = projectCacheFolder.resolve("patches-client.lzma");
        this.serverPatches = projectCacheFolder.resolve("patches-server.lzma");
        try {
            Files.createDirectories(projectCacheFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getTargetConfig() {
        return "forgeInstaller";
    }
}

