/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.dependency;

import dev.architectury.loom.forge.ModDirTransformerDiscovererPatch;
import dev.architectury.loom.forge.RemapObjectHolderVisitor;
import dev.architectury.loom.forge.dependency.DependencyProvider;
import dev.architectury.loom.mappings.ForgeMappingsMerger;
import dev.architectury.loom.mappings.MappingOption;
import dev.architectury.loom.neoforge.StringConstantPatcher;
import dev.architectury.loom.util.ClassVisitorUtil;
import dev.architectury.loom.util.PropertyUtil;
import dev.architectury.loom.util.Version;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.mods.ModConfigurationRemapper;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.providers.mappings.GradleMappingContext;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.service.ScopedServiceFactory;
import net.fabricmc.loom.util.service.ServiceFactory;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MappingTreeView;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.objectweb.asm.ClassVisitor;

public class ForgeLibrariesProvider {
    private static final String FML_PATCH_VERSION = "-loom-patch-v1";
    private static final String FML_LOADER_GROUP = "net.minecraftforge";
    private static final String FML_LOADER_NAME = "fmlloader";
    private static final String FANCYML_LOADER_GROUP = "net.neoforged.fancymodloader";
    private static final String FANCYML_LOADER_NAME = "loader";
    private static final Version FANCYML_LOADER_UNPROTECT_BACKEND_VERSION = Version.parse("10.0.14");
    private static final String FORGE_OBJECT_HOLDER_FILE = "net/minecraftforge/fml/common/asm/ObjectHolderDefinalize.class";
    private static final String FORGE_MOD_DIR_TRANSFORMER_DISCOVERER_FILE = "net/minecraftforge/fml/loading/ModDirTransformerDiscoverer.class";
    private static final String NEOFORGE_OBJECT_HOLDER_FILE = "net/neoforged/fml/common/asm/ObjectHolderDefinalize.class";
    private static final String NEOFORGE_LAUNCH_HANDLER_FILE = "net/neoforged/fml/loading/targets/CommonUserdevLaunchHandler.class";
    private static final String NEOFORGE_LOADER_FILE = "net/neoforged/fml/loading/FMLLoader.class";
    private static final String NEOFORGE_GAME_LOCATOR_FILE = "net/neoforged/fml/loading/moddiscovery/locators/GameLocator.class";
    private static final String NEOFORGE_REQUIRED_SYSTEM_FILES_FILE = "net/neoforged/fml/loading/moddiscovery/locators/RequiredSystemFiles.class";

    public static void provide(MappingConfiguration mappingConfiguration, Project project) throws Exception {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String lib : extension.getForgeUserdevProvider().getConfig().libraries()) {
            String version;
            Object dep = null;
            if (lib.startsWith("org.spongepowered:mixin:") && extension.isForge() && ((Boolean)PropertyUtil.getAndFinalize(extension.getForge().getUseCustomMixin())).booleanValue()) {
                if (lib.contains("0.8.2")) {
                    dep = "net.fabricmc:sponge-mixin:0.8.2+build.24";
                } else {
                    version = lib.substring(lib.lastIndexOf(":"));
                    int atIndex = version.indexOf(64);
                    if (atIndex >= 0) {
                        version = version.substring(0, atIndex);
                    }
                    dep = "dev.architectury:mixin-patched" + version + ".+";
                }
            }
            if (lib.startsWith("net.minecraftforge:bootstrap:") && extension.isForge() && extension.getForgeProvider().getVersion().getMajorVersion() >= 49) {
                version = lib.substring(lib.lastIndexOf(":"));
                dependencies.add(project.getDependencies().create((Object)("net.minecraftforge:bootstrap-dev" + version)));
            }
            if (dep == null) {
                dep = lib;
            }
            dependencies.add(project.getDependencies().create(dep));
        }
        ResolvedConfiguration config = project.getConfigurations().detachedConfiguration(dependencies.toArray(new Dependency[0])).getResolvedConfiguration();
        boolean isFancyModLoader10OrNewer = false;
        for (ResolvedArtifact artifact : config.getResolvedArtifacts()) {
            Object dep;
            block21: {
                boolean isFancyML;
                ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
                boolean isFML = FML_LOADER_GROUP.equals(id.getGroup()) && FML_LOADER_NAME.equals(id.getName());
                boolean bl = isFancyML = FANCYML_LOADER_GROUP.equals(id.getGroup()) && FANCYML_LOADER_NAME.equals(id.getName());
                if (isFancyML && extension.isNeoForge() && Version.parse(id.getVersion()).compareTo(FANCYML_LOADER_UNPROTECT_BACKEND_VERSION) >= 0) {
                    isFancyModLoader10OrNewer = true;
                }
                if (isFML || isFancyML) {
                    try (ScopedServiceFactory serviceFactory = new ScopedServiceFactory();){
                        if (isFML) {
                            project.getLogger().info(":remapping FML loader");
                        } else if (isFancyML) {
                            project.getLogger().info(":remapping FancyML loader");
                        }
                        dep = ForgeLibrariesProvider.remapFmlLoader(project, serviceFactory, artifact, mappingConfiguration);
                        break block21;
                    }
                    catch (IOException e) {
                        throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Could not remap FML", e);
                    }
                }
                dep = project.getDependencies().create((Object)ForgeLibrariesProvider.getDependencyNotation(artifact));
                if (dep instanceof ModuleDependency) {
                    ModuleDependency md = (ModuleDependency)dep;
                    md.setTransitive(false);
                }
            }
            DependencyProvider.addDependency(project, dep, "forgeDependencies");
        }
        LoomVersions unprotect = isFancyModLoader10OrNewer ? LoomVersions.UNPROTECT_FANCYMODLOADER10 : LoomVersions.UNPROTECT_MODLAUNCHER;
        DependencyProvider.addDependency(project, unprotect.mavenNotation(), "forgeExtra");
    }

    private static Object remapFmlLoader(Project project, ServiceFactory serviceFactory, ResolvedArtifact artifact, MappingConfiguration mappingConfiguration) throws IOException {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        String mappingHash = Checksum.of(mappingConfiguration.mappingsIdentifier() + FML_PATCH_VERSION).sha256().hex();
        ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
        LocalMavenHelper mavenHelper = new LocalMavenHelper(id.getGroup() + "." + mappingHash, id.getName(), id.getVersion(), artifact.getClassifier(), extension.getFiles().getForgeDependencyRepo().toPath());
        Path inputJar = artifact.getFile().toPath();
        Path outputJar = mavenHelper.getOutputFile(null);
        TinyMappingsService mappingsService = mappingConfiguration.getMappingsService(project, serviceFactory, MappingOption.DEFAULT);
        MemoryMappingTree mappings = mappingsService.getMappingTree();
        if (!Files.exists(outputJar, new LinkOption[0]) || extension.refreshDeps()) {
            Map<ResolvedArtifact, Path> sourcesByArtifact;
            Path sourcesJar;
            mavenHelper.copyToMaven(inputJar, null);
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(outputJar, false);){
                Path path = fs.get().getPath("META-INF/services/cpw.mods.modlauncher.api.INameMappingService", new String[0]);
                Files.deleteIfExists(path);
                if (Files.exists(fs.get().getPath(FORGE_OBJECT_HOLDER_FILE, new String[0]), new LinkOption[0])) {
                    ForgeLibrariesProvider.remapObjectHolder(project, outputJar, mappingConfiguration);
                }
                if (Files.exists(fs.getPath(FORGE_MOD_DIR_TRANSFORMER_DISCOVERER_FILE, new String[0]), new LinkOption[0])) {
                    ClassVisitorUtil.rewriteClassFile(fs.getPath(FORGE_MOD_DIR_TRANSFORMER_DISCOVERER_FILE, new String[0]), true, ModDirTransformerDiscovererPatch::new);
                }
                if (Files.exists(fs.getPath(NEOFORGE_OBJECT_HOLDER_FILE, new String[0]), new LinkOption[0])) {
                    ForgeLibrariesProvider.remapNeoForgeObjectHolder(project, outputJar, mappingConfiguration);
                }
                if (Files.exists(fs.getPath(NEOFORGE_LAUNCH_HANDLER_FILE, new String[0]), new LinkOption[0])) {
                    ClassVisitorUtil.rewriteClassFile(fs.getPath(NEOFORGE_LAUNCH_HANDLER_FILE, new String[0]), StringConstantPatcher::forUserdevLaunchHandler);
                }
                if (Files.exists(fs.getPath(NEOFORGE_LOADER_FILE, new String[0]), new LinkOption[0])) {
                    ClassVisitorUtil.rewriteClassFile(fs.getPath(NEOFORGE_LOADER_FILE, new String[0]), arg_0 -> ForgeLibrariesProvider.lambda$remapFmlLoader$0((MappingTree)mappings, arg_0));
                }
                if (Files.exists(fs.getPath(NEOFORGE_GAME_LOCATOR_FILE, new String[0]), new LinkOption[0])) {
                    ClassVisitorUtil.rewriteClassFile(fs.getPath(NEOFORGE_GAME_LOCATOR_FILE, new String[0]), arg_0 -> ForgeLibrariesProvider.lambda$remapFmlLoader$1((MappingTree)mappings, arg_0));
                }
                if (Files.exists(fs.getPath(NEOFORGE_REQUIRED_SYSTEM_FILES_FILE, new String[0]), new LinkOption[0])) {
                    ClassVisitorUtil.rewriteClassFile(fs.getPath(NEOFORGE_REQUIRED_SYSTEM_FILES_FILE, new String[0]), arg_0 -> ForgeLibrariesProvider.lambda$remapFmlLoader$2((MappingTree)mappings, arg_0));
                }
            }
            if (!ModConfigurationRemapper.isCIBuild() && (sourcesJar = (sourcesByArtifact = ModConfigurationRemapper.downloadAllSources(project, Set.of(artifact))).get(artifact)) != null) {
                mavenHelper.copyToMaven(sourcesJar, "sources");
            }
        }
        return mavenHelper.getNotation();
    }

    private static void remapObjectHolder(Project project, Path outputJar, MappingConfiguration mappingConfiguration) throws IOException {
        try {
            ForgeMappingsMerger.ExtraMappings extraMappings = ForgeMappingsMerger.ExtraMappings.ofMojmapTsrg(MappingConfiguration.getMojmapSrgFileIfPossible(project));
            MemoryMappingTree mappings = ForgeMappingsMerger.mergeSrg(MappingConfiguration.getRawSrgFile(project), mappingConfiguration.tinyMappings, extraMappings, true);
            RemapObjectHolderVisitor.remapObjectHolder(outputJar, "net.minecraftforge.fml.common.asm.ObjectHolderDefinalize", (MappingTree)mappings, MappingsNamespace.SRG.toString(), MappingsNamespace.NAMED.toString());
        }
        catch (IOException e) {
            throw new IOException("Could not remap object holders in " + String.valueOf(outputJar), e);
        }
    }

    private static void remapNeoForgeObjectHolder(Project project, Path outputJar, MappingConfiguration mappingConfiguration) throws IOException {
        try {
            GradleMappingContext context = new GradleMappingContext(project, "tmp-neoforge-libs");
            MemoryMappingTree mappings = ForgeMappingsMerger.mergeMojang(context, mappingConfiguration.tinyMappings, null, true);
            RemapObjectHolderVisitor.remapObjectHolder(outputJar, "net.neoforged.fml.common.asm.ObjectHolderDefinalize", (MappingTree)mappings, MappingsNamespace.MOJANG.toString(), MappingsNamespace.NAMED.toString());
        }
        catch (IOException e) {
            throw new IOException("Could not remap object holders in " + String.valueOf(outputJar), e);
        }
    }

    private static String getDependencyNotation(ResolvedArtifact artifact) {
        ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
        Object notation = "%s:%s:%s".formatted(id.getGroup(), id.getName(), id.getVersion());
        if (artifact.getClassifier() != null) {
            notation = (String)notation + ":" + artifact.getClassifier();
        }
        return notation;
    }

    private static /* synthetic */ ClassVisitor lambda$remapFmlLoader$2(MappingTree mappings, ClassVisitor next) {
        return StringConstantPatcher.forRequiredSystemFiles(next, (MappingTreeView)mappings);
    }

    private static /* synthetic */ ClassVisitor lambda$remapFmlLoader$1(MappingTree mappings, ClassVisitor next) {
        return StringConstantPatcher.forGameLocator(next, (MappingTreeView)mappings);
    }

    private static /* synthetic */ ClassVisitor lambda$remapFmlLoader$0(MappingTree mappings, ClassVisitor next) {
        return StringConstantPatcher.forFmlLoader(next, (MappingTreeView)mappings);
    }
}

