/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.loom.forge.config.ConfigValue;
import dev.architectury.loom.util.collection.CollectionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import org.gradle.api.Named;

public record ForgeRunTemplate(String name, String main, List<ConfigValue> args, List<ConfigValue> jvmArgs, Map<String, ConfigValue> env, Map<String, ConfigValue> props) implements Named
{
    public static final Codec<ForgeRunTemplate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(ForgeRunTemplate::name), (App)Codec.STRING.fieldOf("main").forGetter(ForgeRunTemplate::main), (App)ConfigValue.CODEC.listOf().optionalFieldOf("args", List.of()).forGetter(ForgeRunTemplate::args), (App)ConfigValue.CODEC.listOf().optionalFieldOf("jvmArgs", List.of()).forGetter(ForgeRunTemplate::jvmArgs), (App)Codec.unboundedMap((Codec)Codec.STRING, ConfigValue.CODEC).optionalFieldOf("env", Map.of()).forGetter(ForgeRunTemplate::env), (App)Codec.unboundedMap((Codec)Codec.STRING, ConfigValue.CODEC).optionalFieldOf("props", Map.of()).forGetter(ForgeRunTemplate::props)).apply((Applicative)instance, ForgeRunTemplate::new));
    public static final Codec<Map<String, ForgeRunTemplate>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CODEC).xmap(map -> {
        HashMap<String, ForgeRunTemplate> newMap = new HashMap<String, ForgeRunTemplate>();
        for (Map.Entry entry : map.entrySet()) {
            String name = ((String)entry.getKey()).replaceAll("clientData", "dataClient").replaceAll("serverData", "dataServer");
            newMap.put(name, (ForgeRunTemplate)entry.getValue());
        }
        for (Map.Entry entry : newMap.entrySet()) {
            ForgeRunTemplate template = (ForgeRunTemplate)entry.getValue();
            if (!template.name.isEmpty()) continue;
            ForgeRunTemplate completed = new ForgeRunTemplate((String)entry.getKey(), template.main, template.args, template.jvmArgs, template.env, template.props);
            entry.setValue(completed);
        }
        return newMap;
    }, Function.identity());

    public String getName() {
        return this.name;
    }

    public void applyTo(RunConfigSettings settings, ConfigValue.Resolver configValueResolver) {
        if (settings.getDefaultMainClass().equals("[Forge] Main class has not been determined yet!")) {
            settings.defaultMainClass(this.main);
        }
        settings.vmArgs(CollectionUtil.map(this.jvmArgs, value -> value.resolve(configValueResolver)));
        this.env.forEach((key, value) -> {
            String resolved = value.resolve(configValueResolver);
            settings.getEnvironmentVariables().putIfAbsent((String)key, resolved);
        });
        settings.getEnvironmentVariables().putIfAbsent("MOD_CLASSES", "{source_roots}");
    }

    public Resolved resolve(ConfigValue.Resolver configValueResolver) {
        Function<ConfigValue, String> resolve = value -> value.resolve(configValueResolver);
        Collector<Map.Entry, ?, Map<String, String>> resolveMap = Collectors.toMap(Map.Entry::getKey, entry -> ((ConfigValue)entry.getValue()).resolve(configValueResolver));
        List args = this.args.stream().map(resolve).collect(Collectors.toCollection(ArrayList::new));
        List jvmArgs = this.jvmArgs.stream().map(resolve).collect(Collectors.toCollection(ArrayList::new));
        Map<String, String> env = this.env.entrySet().stream().collect(resolveMap);
        Map<String, String> props = this.props.entrySet().stream().collect(resolveMap);
        return new Resolved(this.name, this.main, args, jvmArgs, env, props);
    }

    public record Resolved(String name, String main, List<String> args, List<String> jvmArgs, Map<String, String> env, Map<String, String> props) implements Serializable
    {
    }
}

