/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.mappingio.tree.MappingTree;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class RemapObjectHolderVisitor
extends ClassVisitor {
    private final MappingTree mappings;
    private final int from;
    private final int to;

    public RemapObjectHolderVisitor(int api, ClassVisitor classVisitor, MappingTree mappings, String from, String to) {
        super(api, classVisitor);
        this.mappings = mappings;
        this.from = this.mappings.getNamespaceId(from);
        this.to = this.mappings.getNamespaceId(to);
    }

    public static void remapObjectHolder(Path jar, String className, MappingTree mappings, String from, String to) throws IOException {
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar, false);){
            Path classPath = fs.get().getPath(className.replace('.', '/') + ".class", new String[0]);
            if (Files.exists(classPath, new LinkOption[0])) {
                ClassReader reader = new ClassReader(Files.readAllBytes(classPath));
                ClassWriter writer = new ClassWriter(0);
                RemapObjectHolderVisitor classVisitor = new RemapObjectHolderVisitor(589824, (ClassVisitor)writer, mappings, from, to);
                reader.accept((ClassVisitor)classVisitor, 0);
                Files.write(classPath, writer.toByteArray(), StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        if ("<clinit>".equals(name) && "()V".equals(descriptor) && this.from != -2 && this.to != -2) {
            return new MethodVisitor(this.api, methodVisitor){

                public void visitLdcInsn(Object value) {
                    String str;
                    if (value instanceof String && (str = (String)value).startsWith("net.minecraft.")) {
                        value = RemapObjectHolderVisitor.this.mappings.mapClassName(str.replace('.', '/'), RemapObjectHolderVisitor.this.from, RemapObjectHolderVisitor.this.to).replace('/', '.');
                    }
                    super.visitLdcInsn(value);
                }
            };
        }
        return methodVisitor;
    }
}

