/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.architectury.loom.forge.MappingsMigrator;
import dev.architectury.loom.forge.minecraft.MinecraftPatchedProvider;
import dev.architectury.loom.util.collection.Multimap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.Set;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.Pair;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public final class MethodInheritanceMappingsMigrator
implements MappingsMigrator {
    private Set<Pair<String, String>> methodsToRemove;

    @Override
    public long setup(Project project, MinecraftProvider minecraftProvider, Path cache, Path rawMappings, boolean hasSrg, boolean hasMojang) throws IOException {
        Path cacheFile = cache.resolve("method-inheritance-migrator.json");
        if (!minecraftProvider.refreshDeps() && Files.exists(cacheFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(cacheFile);){
                List list = (List)new Gson().fromJson((Reader)reader, (TypeToken)new TypeToken<List<Pair<String, String>>>(this){});
                this.methodsToRemove = new HashSet<Pair<String, String>>(list);
            }
        } else {
            Files.deleteIfExists(cacheFile);
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            Path patchedIntermediateJar = MinecraftPatchedProvider.get(project).getMinecraftPatchedIntermediateJar();
            List<Path> jars = List.of(patchedIntermediateJar, extension.getForgeUniversalProvider().getForge().toPath(), extension.getForgeUserdevProvider().getUserdevJar().toPath());
            this.methodsToRemove = this.prepareCache(project.getLogger(), rawMappings, jars, hasSrg, hasMojang);
            Files.writeString(cacheFile, (CharSequence)new Gson().toJson(this.methodsToRemove.stream().sorted(Comparator.comparing(p -> (String)p.left() + "|" + (String)p.right())).toList()), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        return this.methodsToRemove.hashCode();
    }

    @Override
    public void migrate(Project project, List<MappingsMigrator.MappingsEntry> entries) throws IOException {
        for (MappingsMigrator.MappingsEntry entry : entries) {
            MemoryMappingTree mappings = new MemoryMappingTree();
            try (BufferedReader reader = Files.newBufferedReader(entry.path());){
                MappingReader.read((Reader)reader, (MappingVisitor)mappings);
            }
            for (MappingTree.ClassMapping classMapping : mappings.getClasses()) {
                for (MappingTree.MethodMapping method : List.copyOf(classMapping.getMethods())) {
                    Pair<String, String> key = new Pair<String, String>(method.getName(MappingsNamespace.INTERMEDIARY.toString()), method.getDesc(MappingsNamespace.INTERMEDIARY.toString()));
                    if (!this.methodsToRemove.contains(key)) continue;
                    classMapping.removeMethod(method.getSrcName(), method.getSrcDesc());
                }
            }
            BufferedWriter writer = Files.newBufferedWriter(entry.path(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            try {
                mappings.accept((MappingVisitor)new Tiny2FileWriter((Writer)writer, false));
            }
            finally {
                if (writer == null) continue;
                ((Writer)writer).close();
            }
        }
    }

    private Set<Pair<String, String>> prepareCache(Logger logger, Path rawMappings, List<Path> jars, boolean hasSrg, boolean hasMojang) throws IOException {
        MemoryMappingTree mappings = new MemoryMappingTree();
        String patchedNs = hasSrg ? MappingsNamespace.SRG.toString() : MappingsNamespace.MOJANG.toString();
        try (BufferedReader reader = Files.newBufferedReader(rawMappings);){
            MappingReader.read((Reader)reader, (MappingVisitor)new MappingSourceNsSwitch((MappingVisitor)mappings, patchedNs));
        }
        Pair<Multimap<String, String>, Set<MethodKey>> collected = MethodInheritanceMappingsMigrator.collectClassesAndMethods(jars);
        Multimap<String, String> classInheritanceMap = collected.left();
        Set<MethodKey> methods = collected.right();
        Multimap.Specialized<MethodKey, MethodKey, SequencedSet<MethodKey>> overriddenIntermediaries = Multimap.setMultimap();
        for (MethodKey method : methods) {
            MappingTree.MethodMapping aMethod;
            MappingTree.ClassMapping aClass = mappings.getClass(method.className());
            if (aClass == null || (aMethod = aClass.getMethod(method.name(), method.descriptor())) == null) continue;
            String intermediaryClassName = aClass.getName(MappingsNamespace.INTERMEDIARY.toString());
            String intermediaryName = aMethod.getName(MappingsNamespace.INTERMEDIARY.toString());
            if (intermediaryName == null || Objects.equals(intermediaryName, method.name())) continue;
            for (String superClass : classInheritanceMap.get(method.className())) {
                MethodKey superMethodKey = new MethodKey(superClass, method.name(), method.descriptor());
                if (!methods.contains(superMethodKey)) continue;
                MappingTree.ClassMapping sClass = mappings.getClass(superClass);
                if (sClass == null) {
                    logger.info("Method {}.{}{} is inherited from a class {} that is not in the mappings, removing it if there are more than one", new Object[]{method.className(), method.name(), method.descriptor(), superClass});
                } else {
                    if (sClass.getMethod(method.name(), method.descriptor()) != null) continue;
                    logger.info("Method {}.{}{} is inheriting a method in {} that is not in the mappings, removing it if there are more than one", new Object[]{method.className(), method.name(), method.descriptor(), superClass});
                }
                String intermediaryDesc = aMethod.getDesc(MappingsNamespace.INTERMEDIARY.toString());
                overriddenIntermediaries.put(superMethodKey, new MethodKey(intermediaryClassName, intermediaryName, intermediaryDesc));
            }
        }
        HashSet<Pair<String, String>> methodsToRemove = new HashSet<Pair<String, String>>();
        for (Map.Entry entry : overriddenIntermediaries.entrySet()) {
            if (entry.getValue().size() < 2) continue;
            for (MethodKey methodKey : entry.getValue()) {
                methodsToRemove.add(new Pair<String, String>(methodKey.name(), methodKey.descriptor()));
                logger.info("Removing method {}{} from the mappings", (Object)methodKey.name(), (Object)methodKey.descriptor());
            }
        }
        return methodsToRemove;
    }

    private static Pair<Multimap<String, String>, Set<MethodKey>> collectClassesAndMethods(Iterable<Path> jars) throws IOException {
        Multimap.Specialized classInheritanceMap = Multimap.setMultimap();
        HashSet<MethodKey> methods = new HashSet<MethodKey>();
        Visitor visitor = new Visitor(589824, classInheritanceMap, methods);
        for (Path jar : jars) {
            FileSystemUtil.Delegate system = FileSystemUtil.getJarFileSystem(jar, false);
            try {
                for (Path fsPath : Files.walk(system.get().getPath("/", new String[0]), new FileVisitOption[0])::iterator) {
                    if (!Files.isRegularFile(fsPath, new LinkOption[0]) || !fsPath.toString().endsWith(".class")) continue;
                    new ClassReader(Files.readAllBytes(fsPath)).accept((ClassVisitor)visitor, 7);
                }
            }
            finally {
                if (system == null) continue;
                system.close();
            }
        }
        Multimap.Specialized<String, String, SequencedSet<String>> classes = Multimap.setMultimap();
        for (Map.Entry entry : classInheritanceMap.entrySet()) {
            HashSet<String> allSuperClasses = new HashSet<String>();
            for (String superClass : entry.getValue()) {
                MethodInheritanceMappingsMigrator.collectSuperClasses(superClass, new HashSet<String>(), allSuperClasses, classInheritanceMap);
            }
            classes.putAll((String)entry.getKey(), allSuperClasses);
        }
        return new Pair<Multimap<String, String>, Set<MethodKey>>(classes, methods);
    }

    private static void collectSuperClasses(String className, Set<String> travelled, Set<String> allSuperClasses, Multimap<String, String> classInheritanceMap) {
        if (className != null && !className.isEmpty()) {
            allSuperClasses.add(className);
            for (String superClass : classInheritanceMap.get(className)) {
                if (!travelled.add(superClass)) continue;
                MethodInheritanceMappingsMigrator.collectSuperClasses(superClass, travelled, allSuperClasses, classInheritanceMap);
            }
        }
    }

    private record MethodKey(String className, String name, String descriptor) {
    }

    private static class Visitor
    extends ClassVisitor {
        private final Multimap<String, String> classInheritanceMap;
        private final Set<MethodKey> methods;
        private String lastClass = null;

        Visitor(int api, Multimap<String, String> classInheritanceMap, Set<MethodKey> methods) {
            super(api);
            this.classInheritanceMap = classInheritanceMap;
            this.methods = methods;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.lastClass = name;
            this.classInheritanceMap.put(name, superName);
            this.classInheritanceMap.putAll(name, Arrays.asList(interfaces));
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            this.methods.add(new MethodKey(this.lastClass, name, descriptor));
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }
}

