/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.StringJoiner;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.util.FileSystemUtil;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class ForgeLoggerConfig {
    private static final List<ArtifactCoordinates> LOGGER_CONFIG_ARTIFACTS = List.of(new ArtifactCoordinates("net.minecraftforge", "fmlloader", null), new ArtifactCoordinates("net.minecraftforge", "forge", "launcher"));

    @Nullable
    public static File getForgeLoggerConfigSource(Project project) {
        List<String> libraries = LoomGradleExtension.get(project).getForgeUserdevProvider().getConfig().libraries();
        for (String library : libraries) {
            if (!LOGGER_CONFIG_ARTIFACTS.stream().anyMatch(artifact -> artifact.matches(library))) continue;
            return project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().create((Object)library)}).setTransitive(false).getSingleFile();
        }
        return null;
    }

    public static void copyToPath(Path libraryFile, Path outputFile) {
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(libraryFile, false);){
            Path configPath = fs.getPath("log4j2.xml", new String[0]);
            Files.copy(configPath, outputFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Contract(value="-> fail")
    public static void throwNotFound() {
        StringBuilder sb = new StringBuilder("Could not find Forge dependency with logger config. Tried to find:");
        for (ArtifactCoordinates artifact : LOGGER_CONFIG_ARTIFACTS) {
            sb.append('\n').append(" - ").append(artifact);
        }
        throw new RuntimeException(sb.toString());
    }

    private record ArtifactCoordinates(String group, String name, @Nullable String classifier) {
        boolean matches(String notation) {
            String[] parts = notation.split(":");
            return this.group.equals(parts[0]) && this.name.equals(parts[1]) && (this.classifier == null || parts.length >= 4 && this.classifier.equals(parts[3]));
        }

        @Override
        public String toString() {
            StringJoiner joiner = new StringJoiner(":");
            joiner.add(this.group);
            joiner.add(this.name);
            if (this.classifier != null) {
                joiner.add(this.classifier);
            }
            return joiner.toString();
        }
    }
}

