/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.loom.forge;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.loom.util.collection.CollectionUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loom.build.IntermediaryNamespaces;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ModPlatform;
import net.fabricmc.mappingio.tree.MappingTree;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public final class CoreModClassRemapper {
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("^(.*')((?:com\\.mojang\\.|net\\.minecraft\\.)[A-Za-z0-9.-_$]+)('.*)$");
    private static final Pattern REDIRECT_FIELD_TO_METHOD_PATTERN = Pattern.compile("^(.*\\w+\\s*\\.\\s*redirectFieldToMethod\\s*\\(\\s*\\w+\\s*,\\s*')(\\w*)('\\s*,(?:\\s*'(\\w+)'\\s*|.*)\\).*)$");

    public static void remapJar(Project project, ModPlatform platform, Path jar, MappingTree mappings) throws IOException {
        Logger logger = project.getLogger();
        String sourceNamespace = IntermediaryNamespaces.runtimeIntermediary(project);
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar, false);){
            JsonObject coremodsJson;
            Path coremodsJsonPath = fs.getPath("META-INF", "coremods.json");
            if (Files.notExists(coremodsJsonPath, new LinkOption[0])) {
                logger.info(":no coremods in " + String.valueOf(jar.getFileName()));
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(coremodsJsonPath);){
                coremodsJson = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            }
            for (Map.Entry nameFileEntry : coremodsJson.entrySet()) {
                String file = ((JsonElement)nameFileEntry.getValue()).getAsString();
                Path js = fs.getPath(file, new String[0]);
                if (Files.exists(js, new LinkOption[0])) {
                    logger.info(":remapping coremod '" + file + "'");
                    CoreModClassRemapper.remap(js, platform, mappings, sourceNamespace);
                    continue;
                }
                logger.warn("Coremod '" + file + "' listed in coremods.json but not found");
            }
        }
    }

    public static void remap(Path js, ModPlatform platform, MappingTree mappings, String sourceNamespace) throws IOException {
        List<String> lines = Files.readAllLines(js);
        ArrayList<String> output = new ArrayList<String>(lines);
        String lastClassName = null;
        for (int i = 0; i < lines.size(); ++i) {
            String remappedMethod;
            String fieldName;
            String remapped;
            String line = lines.get(i);
            Matcher matcher = CLASS_NAME_PATTERN.matcher(line);
            if (matcher.matches()) {
                String className = matcher.group(2).replace('.', '/');
                lastClassName = remapped = CollectionUtil.find(mappings.getClasses(), def -> def.getName(sourceNamespace).equals(className)).map(def -> def.getName("named")).orElse(className);
                if (className.equals(remapped)) continue;
                output.set(i, matcher.group(1) + remapped.replace('/', '.') + matcher.group(3));
                continue;
            }
            if (platform != ModPlatform.NEOFORGE || lastClassName == null || !(matcher = REDIRECT_FIELD_TO_METHOD_PATTERN.matcher(line)).matches() || (fieldName = matcher.group(2)).equals(remapped = Optional.ofNullable(mappings.getClass(lastClassName, mappings.getNamespaceId("named"))).flatMap(clazz -> Optional.ofNullable(clazz.getField(fieldName, null, mappings.getNamespaceId(sourceNamespace)))).map(field -> field.getName("named")).orElse(fieldName))) continue;
            String optionalMethod = matcher.group(4);
            String string = remappedMethod = optionalMethod == null ? null : (String)Optional.ofNullable(mappings.getClass(lastClassName, mappings.getNamespaceId("named"))).flatMap(clazz -> Optional.ofNullable(clazz.getMethod(optionalMethod, null, mappings.getNamespaceId(sourceNamespace)))).map(method -> method.getName("named")).orElse(null);
            if (remappedMethod != null) {
                output.set(i, matcher.group(1) + remapped + matcher.group(3).replace("'" + optionalMethod + "'", "'" + remappedMethod + "'"));
                continue;
            }
            output.set(i, matcher.group(1) + remapped + matcher.group(3));
        }
        if (!lines.equals(output)) {
            try (BufferedWriter writer = Files.newBufferedWriter(js, StandardCharsets.UTF_8, StandardOpenOption.WRITE);){
                writer.write(String.join((CharSequence)"\n", output));
            }
        }
    }
}

