/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util.fmj;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.loom.metadata.JsonBackedModMetadataFile;
import dev.architectury.loom.metadata.ModMetadataFile;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.loom.util.fmj.FabricModJson;
import net.fabricmc.loom.util.fmj.FabricModJsonSource;
import net.fabricmc.loom.util.fmj.ModEnvironment;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.Nullable;

public final class ModMetadataFabricModJson
extends FabricModJson {
    private static final int FABRIC_SCHEMA_VERSION = -1;
    private final ModMetadataFile modMetadata;
    private final FabricModJsonSource source;

    ModMetadataFabricModJson(ModMetadataFile modMetadata, FabricModJsonSource source) {
        super(ModMetadataFabricModJson.getJsonForModMetadata(modMetadata), source);
        this.modMetadata = modMetadata;
        this.source = source;
    }

    private static JsonObject getJsonForModMetadata(ModMetadataFile modMetadata) {
        if (modMetadata instanceof JsonBackedModMetadataFile) {
            JsonBackedModMetadataFile jsonBacked = (JsonBackedModMetadataFile)modMetadata;
            return jsonBacked.getJson();
        }
        return new JsonObject();
    }

    public ModMetadataFile getModMetadata() {
        return this.modMetadata;
    }

    @Override
    public String getId() {
        return Optional.ofNullable(this.modMetadata.getId()).or(this::getIdFromSource).orElseGet(() -> super.getId());
    }

    private Optional<String> getIdFromSource() {
        FabricModJsonSource fabricModJsonSource = this.source;
        if (fabricModJsonSource instanceof FabricModJsonSource.ZipSource) {
            FabricModJsonSource.ZipSource zip = (FabricModJsonSource.ZipSource)fabricModJsonSource;
            return Optional.of(zip.zipPath().getFileName().toString());
        }
        fabricModJsonSource = this.source;
        if (fabricModJsonSource instanceof FabricModJsonSource.DirectorySource) {
            FabricModJsonSource.DirectorySource directory = (FabricModJsonSource.DirectorySource)fabricModJsonSource;
            return Optional.of(directory.directoryPath().toAbsolutePath().toString());
        }
        fabricModJsonSource = this.source;
        if (fabricModJsonSource instanceof FabricModJsonSource.SourceSetSource) {
            FabricModJsonSource.SourceSetSource sourceSets = (FabricModJsonSource.SourceSetSource)fabricModJsonSource;
            StringJoiner joiner = new StringJoiner("+");
            for (SourceSet sourceSet : sourceSets.sourceSets()) {
                Project project = SourceSetHelper.getSourceSetProject(sourceSet);
                String path = project.getPath();
                StringBuilder sb = new StringBuilder(path);
                if (!path.endsWith(":")) {
                    sb.append(':');
                }
                sb.append(sourceSet.getName());
                joiner.add(sb.toString());
            }
            return Optional.of(joiner.toString());
        }
        return Optional.empty();
    }

    @Override
    public int getVersion() {
        return -1;
    }

    @Override
    @Nullable
    public JsonElement getCustom(String key) {
        ModMetadataFile modMetadataFile = this.modMetadata;
        if (modMetadataFile instanceof JsonBackedModMetadataFile) {
            JsonBackedModMetadataFile jsonBacked = (JsonBackedModMetadataFile)modMetadataFile;
            return jsonBacked.getCustomValue(key);
        }
        return null;
    }

    @Override
    public List<String> getMixinConfigurations() {
        return this.modMetadata.getMixinConfigs();
    }

    @Override
    public Map<String, ModEnvironment> getClassTweakers() {
        return this.modMetadata.getAccessWideners().stream().collect(Collectors.toMap(Function.identity(), path -> ModEnvironment.UNIVERSAL));
    }
}

